<?php
/*
 * The Template for displaying all posts
 * 
 */
 $fudee_redux_demo = get_option('redux_demo');
get_header(); ?>


<?php if(isset($fudee_redux_demo['blog_image']['url']) && $fudee_redux_demo['blog_image']['url'] != ''){?> 
<section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo esc_url($fudee_redux_demo['blog_image']['url']);?>)">
<?php }else{?>
<section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo (get_template_directory_uri().'/assets/img/bg/breadcrumb-bg.jpg');?>)">
<?php } ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-8 text-center">
            <div class="breadcrumb-content">
                <h3 class="title"><?php printf( esc_html__( 'Search Results for: %s', 'fudee' ), get_search_query() ); ?></h3>
            </div>
        </div>
    </div>
</div>
</section>
<!--    breadcrumb-area end    -->

<!--    about-area start    -->
<div class="blog-grid-area pt-130 pb-100">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-8">
                <?php if ( have_posts() ) :
                while (have_posts()): the_post();
                    ?> 
                <article class="blog-wrap mb-40">
                    <?php if ( has_post_thumbnail() ) { ?>
                    <div class="blog-wrap-thumb">
                        <a href="<?php the_permalink();?>">
                            <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="blog">
                        </a>
                    </div>
                    <?php } ?>
                    <div class="blog-wrap-details">
                        <div class="blog-wrap-meta mb-15">
                            <span><i class="far fa-calendar-check"></i> <?php the_time(get_option( 'date_format'));?> </span>
                            <span><a href="#"><i class="far fa-user"></i> <?php the_author_posts_link(); ?></a></span>
                            <span><a href="#"><i class="far fa-comments"></i> <?php comments_number( esc_html__('0 Comments', 'fudee'), 
                                      esc_html__('1 Comment', 'fudee'), esc_html__('% Comments', 'fudee') ); ?></a></span>
                        </div>
                        <h3 class="blog-wrap-title">
                            <a href="<?php the_permalink();?>">
                                <?php the_title();?>
                            </a>
                        </h3>
                        <div class="blog-wrap-text mb-20">
                            <p>
                                <?php if(isset($fudee_redux_demo['blog_excerpt'])){?>
                                    <?php echo esc_attr(fudee_excerpt($fudee_redux_demo['blog_excerpt'])); ?>
                                    <?php }else{?>
                                    <?php echo esc_attr(fudee_excerpt(50)); 
                                    }?>
                            </p>
                        </div>
                        <div class="read-more mt-30">
                            <a href="<?php the_permalink();?>" class="a-btn btn-theme"><?php if(isset($fudee_redux_demo['read_more'])){?>
                                <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['read_more']));?>
                            <?php }else{?>
                                <?php echo esc_html__( 'Read more', 'fudee' );
                            }
                            ?></a>
                        </div>
                    </div>
                </article>
            <?php endwhile; else :?>
                <div class="search-custom" ><h4><?php
                    // If no content, include the "No posts found" template.
                    echo esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fudee' ) ;?></h4>

                    <?php get_search_form();  ?>
                </div>
            <?php endif;?>
                
                <div class="blog-pagination">
                    <?php fudee_pagination();?>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-10">
                <div class="blog-sidebar">
                    <?php get_sidebar();?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
    get_footer();
?>