<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php $fudee_redux_demo = get_option('redux_demo'); ?>
<head>
    <!-- Meta Tags -->
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
        ?>
    <link rel="shortcut icon" href="<?php if(isset($fudee_redux_demo['favicon']['url'])){?><?php echo esc_url($fudee_redux_demo['favicon']['url']); ?><?php }?>">
    <?php }?>
    <?php wp_head(); ?> 

</head>
<body <?php body_class('home-page-2'); ?>>
<!-- start preloader -->
<div id="preloader">
    <div class="preloader">
        <span></span>
        <span></span>
    </div>
</div>
<!-- preloader end  -->

<!--    header-area start    -->
<div class="header-area">
    <div class="header-top-3">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-8 text-center text-xl-left mb-lg-10 mb-md-10">
                    <div class="header-info">
                        <a href="#"><i class="fal fa-phone-alt"></i> +012 (345) 789999</a>
                    </div>
                    <div class="header-info">
                        <a href="#"><i class="far fa-envelope-open"></i> support@gmail.com</a>
                    </div>
                    <div class="header-info">
                        <a href="#"><i class="far fa-map-marker-alt"></i> 205 New Road, New York</a>
                    </div>
                </div>
                <div class="col-xl-4 text-center text-xl-right">
                    <div class="header-btn-3">
                        <a href="#">Setting & Privacy</a>
                    </div>
                    <div class="header-social-3">
                        <a href="#"><i class="fab fa-facebook-f"></i></a>
                        <a href="#"><i class="fab fa-twitter"></i></a>
                        <a href="#"><i class="fab fa-google-plus-g"></i></a>
                        <a href="#"><i class="fab fa-behance"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header-bottom-3">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-xl-2 col-lg-3 col-md-4 col-6">
                    <?php if(isset($fudee_redux_demo['header_logo_2']['url']) && $fudee_redux_demo['header_logo_2'] != ''){?>
                        <div class="logo-3">
                            <a href="<?php echo esc_url(home_url('/')); ?>">
                                <img src="<?php echo esc_url($fudee_redux_demo['header_logo_2']['url']);?>" alt="logo">
                            </a>
                        </div>
                    <?php }else{?>
                        <div class="logo-3 ">
                            <a href="<?php echo esc_url(home_url('/')); ?>">
                                <img src="<?php echo (get_template_directory_uri().'/assets/img/logo/logo-black.png');?>" alt="logo">
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="col-xl-8 d-none d-xl-block">
                    <div class="main-menu-wrap-2 main-menu-wrap-3">
                        <nav class="main-menu">
                            <?php 
                            wp_nav_menu( 
                                array( 
                                    'theme_location' => 'primary',
                                    'container' => '',
                                    'menu_class' => '', 
                                    'menu_id' => '',
                                    'menu'            => '',
                                    'container_class' => '',
                                    'container_id'    => '',
                                    'echo'            => true,
                                    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                    'walker'            => new fudee_wp_bootstrap_navwalker(),
                                    'before'          => '',
                                    'after'           => '',
                                    'link_before'     => '',
                                    'link_after'      => '',
                                    'items_wrap'      => '<ul class="%2$s">%3$s</ul>',
                                    'depth'           => 0,        
                                )
                            ); ?>
                        </nav>
                        <div class="header-search-3">
                            <a href="javascript:void(0);"><i class="fas fa-search"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-9 col-md-8 col-6 text-right">
                    <div class="header-search-3 d-inline-block d-xl-none">
                        <a href="javascript:void(0);"><i class="fas fa-search"></i></a>
                    </div>
                    <div class="open-mobile-menu  d-inline-block d-xl-none mr-lg-20 mr-md-20">
                        <a href="javascript:void(0);" class="">
                            <i class="far fa-bars"></i>
                        </a>
                    </div>
                    <div class="header-btn-4 d-inline-block">
                        <a href="http://shtheme.org/demosd/fudeewp/?page_id=67" class="a-btn">contact us </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--    header-area end    -->

<!--    slide-bar Start   -->
<aside class="slide-bar">
    <div class="close-mobile-menu">
        <a href="javascript:void(0);"><i class="fas fa-times"></i></a>
    </div>
    <!--    Mobile Menu Start   -->
    <nav class="side-mobile-menu">
        <?php 
        wp_nav_menu( 
            array( 
                'theme_location' => 'primary',
                'container' => '',
                'menu_class' => '', 
                'menu_id' => '',
                'menu'            => '',
                'container_class' => '',
                'container_id'    => '',
                'echo'            => true,
                'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                'walker'            => new fudee_wp_bootstrap_navwalker(),
                'before'          => '',
                'after'           => '',
                'link_before'     => '',
                'link_after'      => '',
                'items_wrap'      => '<ul id="mobile-menu-active" class="%2$s">%3$s</ul>',
                'depth'           => 0,        
            )
        ); ?>
    </nav>
    <!--    Mobile Menu End    -->

    <!--    Offset Sidebar Start   -->
    <div class="sidebar-widget-wrapper">
        <!-- start side widget -->
        <?php if(isset($fudee_redux_demo['header_logo']) && $fudee_redux_demo['header_logo'] != ''){?>
            <div class="sidebar-widget logo-side">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?php echo esc_url($fudee_redux_demo['header_logo']['url']);?>" alt="logo">
                </a>
            </div>
        <?php }else{?>
            <div class="sidebar-widget logo-side">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?php echo (get_template_directory_uri().'/assets/img/logo/logo.png');?>" alt="logo">
                </a>
            </div>
        <?php } ?>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="info-wdget">
                <h4 class="widget-title"><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_address_title']));?></h4>
                <p>
                    <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_address_subtitle']));?>
                </p>
            </div>
        </div>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="info-wdget">
                <h4 class="widget-title"><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_phone_title']));?></h4>
                <p><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_phone_subtitle_1']));?></p>
                <p><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_phone_subtitle_2']));?></p>
            </div>
        </div>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="info-wdget">
                <h4><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_email_title']));?></h4>
                <p><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_email_subtitle_1']));?></p>
                <p><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_email_subtitle_2']));?></p>
            </div>
        </div>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="instagram">
                <?php if(isset($fudee_redux_demo['header_image_1']['url']) && $fudee_redux_demo['header_image_1']['url'] != ''){?>
                        <a href="#">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_1']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="#">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p1.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_2']['url']) && $fudee_redux_demo['header_image_2']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_2']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p2.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_3']['url']) && $fudee_redux_demo['header_image_3']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_3']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p3.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_4']['url']) && $fudee_redux_demo['header_image_4']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_4']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p4.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_5']['url']) && $fudee_redux_demo['header_image_5']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_5']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p5.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_6']['url']) && $fudee_redux_demo['header_image_6']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_6']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p6.jpg');?>" alt="">
                        </a>
                    <?php } ?>
            </div>
        </div>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="social-widget">
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_facebook']);?>">
                    <i class="fab fa-facebook-f"></i>
                </a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_twitter']);?>">
                    <i class="fab fa-twitter"></i>
                </a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_google']);?>">
                    <i class="fab fa-google-plus-g"></i>
                </a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_instagram']);?>">
                    <i class="fab fa-instagram"></i>
                </a>
            </div>
        </div>
        <!-- end side widget -->
    </div>
    <!--    Offset Sidebar End    -->
</aside>
<div class="body-overlay"></div>
<!--    slide-bar End    -->

<!--    search-area start    -->
<div class="search-area">
    <div class="search-area-bg"></div>
    <a href="#" class="search-close">
        <i class="far fa-times"></i>
    </a>
    <div class="search-form">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8">
                    <?php get_search_form() ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!--    search-area end    -->

<!--    main-area start    -->
<main>