<?php

namespace BdevsElementor\Widget;



use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;

use Elementor\Scheme_Typography;

use Elementor\Group_Control_Border;

use Elementor\Group_Control_Box_Shadow;



/**

 * Bdevs Elementor Widget.

 *

 * Elementor widget that inserts an embbedable content into the page, from any given URL.

 *

 * @since 1.0.0

 */

class BdevsSlider extends \Elementor\Widget_Base {



	/**

	 * Get widget name.

	 *

	 * Retrieve Bdevs Elementor widget name.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget name.

	 */

	public function get_name() {

		return 'bdevs-slider';

	}



	/**

	 * Get widget title.

	 *

	 * Retrieve Bdevs Elementor widget title.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget title.

	 */

	public function get_title() {

		return __( 'Slider Widget', 'bdevs-elementor' );

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve Bdevs Slider widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-favorite';

	}



	/**

	 * Get widget categories.

	 *

	 * Retrieve the list of categories the Bdevs Slider widget belongs to.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return array Widget categories.

	 */

	public function get_categories() {

		return [ 'bdevs-elementor' ];

	}



	public function get_keywords() {

		return [ 'bdevs-slider' ];

	}



	public function get_script_depends() {

		return [ 'bdevs-elementor'];

	}



	// BDT Position

	protected function element_pack_position() {

	    $position_options = [

	        ''              => esc_html__('Default', 'bdevs-elementor'),

	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,

	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,

	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,

	        'center'        => esc_html__('Center', 'bdevs-elementor') ,

	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,

	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,

	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,

	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,

	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,

	    ];



	    return $position_options;

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section_content_slider',

			[

				'label' => esc_html__( 'Slider', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'chose_style',

			[

				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'slider_style_1'  => esc_html__( 'Slider Style 1', 'bdevs-elementor' ),

					'slider_style_2'  => esc_html__( 'Slider Style 2', 'bdevs-elementor' ),

				],

				'default'   => 'slider_style_1',

			]

		);



		$this->add_control(

			'tabs',

			[

				'label' => esc_html__( 'Slider Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [	

				    [

						'name'    => 'image',

						'label'   => esc_html__( 'Slider Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'    => 'image_2',

						'label'   => esc_html__( 'Slider Image 2', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],	

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],



					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_link',

						'label'       => esc_html__( 'Tab Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'       => 'tab_button',

						'label'      => esc_html__( 'Button', 'bdevs-elementor' ),

						'type'       => Controls_Manager::TEXT,

						'dynamic'    => [ 'active' => true ],

						'default'    => esc_html__( '', 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_video_link',

						'label'       => esc_html__( 'Video Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '#' , 'bdevs-elementor' ),

					],

					[

						'name'       => 'tab_video_text',

						'label'      => esc_html__( 'Video Text', 'bdevs-elementor' ),

						'type'       => Controls_Manager::TEXT,

						'dynamic'    => [ 'active' => true ],

						'default'    => esc_html__( '', 'bdevs-elementor' ),

					],

				],

			]

		);



		$this->end_controls_section();





		$this->start_controls_section(

			'section_content_slider_2',

			[

				'label' => esc_html__( 'Slider 2', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'tabs_2',

			[

				'label' => esc_html__( 'Slider Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [	

				    [

						'name'    => 'image',

						'label'   => esc_html__( 'Slider Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],



					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_link_1',

						'label'       => esc_html__( 'Tab Link', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_link_2',

						'label'       => esc_html__( 'Button Link 1', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'       => 'tab_button_1',

						'label'      => esc_html__( 'Button 1', 'bdevs-elementor' ),

						'type'       => Controls_Manager::TEXT,

						'dynamic'    => [ 'active' => true ],

						'default'    => esc_html__( '', 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_link_3',

						'label'       => esc_html__( 'Button Link 2', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'       => 'tab_button_2',

						'label'      => esc_html__( 'Button 2', 'bdevs-elementor' ),

						'type'       => Controls_Manager::TEXT,

						'dynamic'    => [ 'active' => true ],

						'default'    => esc_html__( '', 'bdevs-elementor' ),

						'label_block' => true,

					],

					

				],

			]

		);



		$this->end_controls_section();





		$this->start_controls_section(

			'section_content_layout',

			[

				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),

			]

		);



		$this->add_responsive_control(

			'align',

			[

				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),

				'type'    => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => esc_html__( 'Left', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-left',

					],

					'center' => [

						'title' => esc_html__( 'Center', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-center',

					],

					'right' => [

						'title' => esc_html__( 'Right', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-right',

					],

					'justify' => [

						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-justify',

					],

				],

				'prefix_class' => 'elementor%s-align-',

				'description'  => 'Use align to match position',

				'default'      => 'center',

			]

		);



		$this->end_controls_section();



	}



	public function render() {

		$settings  = $this->get_settings_for_display();

		$chose_style = $settings['chose_style'];

		?>

		

		<?php if( $chose_style == 'slider_style_1' ): ?>

		<div class="slider-area">

		<div class="home-slider home-slider-3">

			<?php 

					foreach ( $settings['tabs'] as $item ) : ?>

			<?php if ( '' !== $item['image']['url'] ) : ?>

			<div class="home-slide home-slide-3" style="background-image: url(<?php echo wp_kses_post($item['image']['url']); ?>)">

			<?php endif; ?>	

				<div class="container">

					<div class="row justify-content-xl-start justify-content-lg-start justify-content-center">

						<div class="col-xl-7 col-lg-8 col-md-10">

							<div class="home-slide-text">

								<?php if ( '' !== $item['tab_subtitle'] ) : ?>

								<div class="home-slide-cat" data-animation="fadeInDown" data-delay="0.5s">

									<a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_subtitle']); ?></a>

								</div>

								<?php endif; ?>	

								<?php if ( '' !== $item['tab_title'] ) : ?>

								<div class="home-slide-title" data-animation="fadeInDown" data-delay="0.8s">

									<h3><?php echo wp_kses_post($item['tab_title']); ?></h3>

								</div>

								<?php endif; ?>	

								<div class="home-slide-btn" data-animation="fadeInDown" data-delay="1.1s">

									<?php if ( '' !== $item['tab_button'] ) : ?>

									<a href="<?php echo wp_kses_post($item['tab_link']); ?>" class="a-btn"><?php echo wp_kses_post($item['tab_button']); ?><i class="fas fa-plus"></i></a>

									<?php endif; ?>	

									<?php if ( '' !== $item['tab_video_text'] ) : ?>

									<a href="<?php echo wp_kses_post($item['tab_video_link']); ?>" class="play-btn popup-video">

										<span><?php echo wp_kses_post($item['tab_video_text']); ?></span>

										<i class="far fa-play-circle"></i>

									</a>

									<?php endif; ?>	

								</div>

							</div>

						</div>

					</div>

				</div>

				<?php if ( '' !== $item['image_2']['url'] ) : ?>

				<div class="home-slide-thumb" data-animation="zoomIn" data-delay="0.5s">

					<img src="<?php echo wp_kses_post($item['image_2']['url']); ?>" alt="slider">

				</div>

				<?php endif; ?>	

			</div>

			<?php

		endforeach;

		?>

		</div>

	</div>



	<?php elseif( $chose_style == 'slider_style_2' ): ?>



		<div class="slider-area">



		<div class="home-slider-2">



			<?php foreach ( $settings['tabs_2'] as $item ) : ?>

			

			<?php if ( '' !== $item['image']['url'] ) : ?>

			<div class="home-slide-2" style="background-image: url(<?php echo wp_kses_post($item['image']['url']); ?>)">

			<?php endif; ?>	



				<div class="container">



					<div class="row justify-content-center">



						<div class="col-xl-12">



							<div class="home-slide-text-2">



								<?php if ( '' !== $item['tab_subtitle'] ) : ?>



								<div class="home-slide-cat" data-animation="fadeInDown" data-delay="0.2s">



									<a href="<?php echo wp_kses_post($item['tab_link_1']); ?>"><?php echo wp_kses_post($item['tab_subtitle']); ?></a>



								</div>



								<?php endif; ?>	



								<?php if ( '' !== $item['tab_title'] ) : ?>



								<div class="home-slide-title" data-animation="zoomIn" data-delay="0.6s">



									<h3><?php echo wp_kses_post($item['tab_title']); ?></h3>



								</div>



								<?php endif; ?>	



								<div class="home-slide-btn">

									

									<?php if ( '' !== $item['tab_button_1'] ) : ?>



									<a href="<?php echo wp_kses_post($item['tab_link_2']); ?>" class="a-btn" data-animation="fadeInLeft" data-delay="1s">



										<?php echo wp_kses_post($item['tab_button_1']); ?> <i class="fas fa-plus"></i>



									</a>



									<?php endif; ?>	

									

									<?php if ( '' !== $item['tab_button_2'] ) : ?>



									<a href="<?php echo wp_kses_post($item['tab_link_3']); ?>" class="b-btn" data-animation="fadeInRight" data-delay="1.2s">



										<?php echo wp_kses_post($item['tab_button_2']); ?> <i class="fas fa-plus"></i>



									</a>



									<?php endif; ?>	



								</div>



							</div>



						</div>



					</div>



				</div>



			</div>



			<?php

		endforeach;

		?>



		</div>



	</div>



	<?php endif; ?>	


<?php if (is_admin()) { ?>
<script type="text/javascript">
	if (jQuery(".home-slider").length > 0) {

		

		var HomeSlider = $('.home-slider');

		HomeSlider.on('init', function (e, slick) {

			var $firstAnimatingElements = $('.home-slide:first-child').find('[data-animation]');

			doAnimations($firstAnimatingElements);

		});

		

		HomeSlider.on('beforeChange', function (e, slick, currentSlide, nextSlide) {

			var $animatingElements = $('.home-slide[data-slick-index="' + nextSlide + '"]').find('[data-animation]');

			doAnimations($animatingElements);

		});

		

		HomeSlider.slick({

			autoplay: true,

			autoplaySpeed: 10000,

			dots: false,

			fade: true,

			arrows: false,

			prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',

			nextArrow: '<button type="button" class="slick-next"><i class="fal fa-arrow-right"></i></button>',

			responsive: [

				{breakpoint: 992, settings: {dots: false, arrows: false}}

			]

		});

	}

	if (jQuery(".home-slider-2").length > 0) {

		

		var HomeSlider2 = $('.home-slider-2');

		HomeSlider2.on('init', function (e, slick) {

			var $firstAnimatingElements = $('.home-slide-2:first-child').find('[data-animation]');

			doAnimations($firstAnimatingElements);

		});

		

		HomeSlider2.on('beforeChange', function (e, slick, currentSlide, nextSlide) {

			var $animatingElements = $('.home-slide-2[data-slick-index="' + nextSlide + '"]').find('[data-animation]');

			doAnimations($animatingElements);

		});

		

		HomeSlider2.slick({

			autoplay: true,

			autoplaySpeed: 10000,

			dots: false,

			fade: true,

			arrows: true,

			prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',

			nextArrow: '<button type="button" class="slick-next"><i class="fal fa-arrow-right"></i></button>',

			responsive: [

				{breakpoint: 992, settings: {dots: false, arrows: false}}

			]

		});

	}

	

	function doAnimations(elements) {

		var animationEndEvents = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';

		elements.each(function () {

			var $this = $(this);

			var $animationDelay = $this.data('delay');

			var $animationType = 'animated ' + $this.data('animation');

			$this.css({

				'animation-delay': $animationDelay,

				'-webkit-animation-delay': $animationDelay

			});

			$this.addClass($animationType).one(animationEndEvents, function () {

				$this.removeClass($animationType);

			});

		});

	}
</script>
<?php }  ?>
	<?php

	}



}