<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
/** * Bdevs Elementor Widget. * * Elementor widget that inserts an embbedable content into the page, from any given URL. * * @since 1.0.0 */
class BdevsService extends \Elementor\Widget_Base {	/**	 * Get widget name.	 *	 * Retrieve Bdevs Elementor widget name.	 *	 * @since 1.0.0	 * @access public	 *	 * @return string Widget name.	 */	
public function get_name() {		return 'bdevs-service';	}	
/**	 * Get widget title.	 *	 * Retrieve Bdevs Elementor widget title.	 *	 * @since 1.0.0	 * @access public	 *	 * @return string Widget title.	 */	
public function get_title() {		return __( 'Service Widget', 'bdevs-elementor' );	}	
/**	 * Get widget icon.	 *	 * Retrieve Bdevs Slider widget icon.	 *	 * @since 1.0.0	 * @access public	 *	 * @return string Widget icon.	 */	
public function get_icon() {		return 'eicon-favorite';	}	
/**	 * Get widget categories.	 *	 * Retrieve the list of categories the Bdevs Slider widget belongs to.	 *	 * @since 1.0.0	 * @access public	 *	 * @return array Widget categories.	 */	
public function get_categories() {		return [ 'bdevs-elementor' ];	}	
public function get_keywords() {		return [ 'bdevs-service' ];	}	
public function get_script_depends() {		return [ 'bdevs-elementor'];	}	
// BDT Position	
	protected function element_pack_position() {	    $position_options = [	        ''              => esc_html__('Default', 'bdevs-elementor'),	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,	        'center'        => esc_html__('Center', 'bdevs-elementor') ,	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,	    ];	    return $position_options;	}	
	protected function _register_controls() {		
		$this->start_controls_section(			'section_content_service',			[				'label' => esc_html__( 'Service', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'chose_style',			[				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),				'type'      => Controls_Manager::SELECT,				'options'   => [					'service_style_1'  => esc_html__( 'Service Style 1', 'bdevs-elementor' ),					'service_style_2' => esc_html__( 'Service Style 2', 'bdevs-elementor' ),					'service_style_3' => esc_html__( 'Service Style 3', 'bdevs-elementor' ),					'service_style_4' => esc_html__( 'Service Style 4', 'bdevs-elementor' ),					'service_style_5' => esc_html__( 'Service Style 5', 'bdevs-elementor' ),					'service_style_6' => esc_html__( 'Service Style 6', 'bdevs-elementor' ),				],				'default'   => 'service_style_1',			]		);		
		$this->add_control(			'post_number',			[				'label'       => __( 'Post Number', 'bdevs-elementor' ),				'type'        => Controls_Manager::NUMBER,				'default'     => __( '4', 'bdevs-elementor' ),				'label_block' => true,			]		);			
		$this->add_control(			'post_order',			[				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),				'type'      => Controls_Manager::SELECT,				'options'   => [					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),				],				'default'   => 'asc',			]		);		
		$this->end_controls_section();		
		$this->start_controls_section(			'section_content_service_2',			[				'label' => esc_html__( 'Service Style 2', 'bdevs-elementor' ),							]		);		
		$this->add_control(			'image_style_2',			[				'label'   => esc_html__( 'Service Image', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Service Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'image_2_style_2',			[				'label'   => esc_html__( 'Service Image 2', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Service Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'shape_image_1',			[				'label'   => esc_html__( 'Shape Image 1', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Shape Image 1', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'shape_image_2',			[				'label'   => esc_html__( 'Shape Image 2', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Shape Image 2', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'heading_style_2',			[				'label'       => __( 'Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);			
		$this->add_control(			'sub_heading_style_2',			[				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'tabs',			[				'label' => esc_html__( 'Service Items', 'bdevs-elementor' ),				'type' => Controls_Manager::REPEATER,				'fields' => [						[						'name'    => 'tab_image',						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),						'type'    => Controls_Manager::MEDIA,						'dynamic' => [ 'active' => true ],						'default'     => __( '', 'bdevs-elementor' ),					],					[						'name'        => 'tab_title',						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Title' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_subtitle',						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Subtitle' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_icon',						'label'       => esc_html__( 'Icon', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Tab Icon' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_link',						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Link' , 'bdevs-elementor' ),						'label_block' => true,					],				],			]		);		
		$this->end_controls_section();		
		$this->start_controls_section(			'section_content_service_3',			[				'label' => esc_html__( 'Service Style 3', 'bdevs-elementor' ),							]		);		
		$this->add_control(			'image_style_3',			[				'label'   => esc_html__( 'Service Image', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Service Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'heading_style_3',			[				'label'       => __( 'Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);			
		$this->add_control(			'sub_heading_style_3',			[				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'content_style_3',			[				'label'       => __( 'Content', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXTAREA,				'placeholder' => __( 'Enter your content', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'link_style_3',			[				'label'       => __( 'Link', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your button', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'button_style_3',			[				'label'       => __( 'Button', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your button', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'tabs_style_3',			[				'label' => esc_html__( 'Service Items', 'bdevs-elementor' ),				'type' => Controls_Manager::REPEATER,				'fields' => [						[						'name'    => 'tab_image',						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),						'type'    => Controls_Manager::MEDIA,						'dynamic' => [ 'active' => true ],						'default'     => __( '', 'bdevs-elementor' ),					],					[						'name'        => 'tab_shape',						'label'       => esc_html__( 'Tab Shape', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( '' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_title',						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Title' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_subtitle',						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Subtitle' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_link',						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Link' , 'bdevs-elementor' ),						'label_block' => true,					],				],			]		);		$this->end_controls_section();		
		$this->start_controls_section(			'section_content_service_4',			[				'label' => esc_html__( 'Service Style 4', 'bdevs-elementor' ),							]		);		
		$this->add_control(			'image_style_4',			[				'label'   => esc_html__( 'Service Image', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Service Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'image_2_style_4',			[				'label'   => esc_html__( 'Service Image 2', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Service Image 2', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'icon_image_style_4',			[				'label'   => esc_html__( 'Service Icon Image', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Service Icon Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'heading_style_4',			[				'label'       => __( 'Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);			
		$this->add_control(			'sub_heading_style_4',			[				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'tabs_style_4',			[				'label' => esc_html__( 'Service Items', 'bdevs-elementor' ),				'type' => Controls_Manager::REPEATER,				'fields' => [						[						'name'    => 'tab_image',						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),						'type'    => Controls_Manager::MEDIA,						'dynamic' => [ 'active' => true ],						'default'     => __( '', 'bdevs-elementor' ),					],					[						'name'        => 'tab_icon',						'label'       => esc_html__( 'Tab Icon', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( '' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_title',						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Title' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_subtitle',						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Subtitle' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_link',						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Link' , 'bdevs-elementor' ),						'label_block' => true,					],				],			]		);		
		$this->end_controls_section();		
		$this->start_controls_section(			'section_content_service_5',			[				'label' => esc_html__( 'Service Style 5', 'bdevs-elementor' ),							]		);		
		$this->add_control(			'icon_image_style_5',			[				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'heading_style_5',			[				'label'       => __( 'Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);			$this->add_control(			'sub_heading_style_5',			[				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'content_style_5',			[				'label'       => __( 'Content', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXTAREA,				'placeholder' => __( 'Enter your content', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'video_title_style_5',			[				'label'       => __( 'Video Title', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your video title', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'video_link_style_5',			[				'label'       => __( 'Video Link', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your video link', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'video_image_style_5',			[				'label'   => esc_html__( 'Video Image', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Video Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'tabs_style_5',			[				'label' => esc_html__( 'Service Items', 'bdevs-elementor' ),				'type' => Controls_Manager::REPEATER,				'fields' => [						[						'name'        => 'tab_icon',						'label'       => esc_html__( 'Icon', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Icon' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_title',						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Title' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_subtitle',						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Subtitle' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_link',						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Link' , 'bdevs-elementor' ),						'label_block' => true,					],				],			]		);		
		$this->end_controls_section();		
		$this->start_controls_section(			'section_content_service_6',			[				'label' => esc_html__( 'Service Style 6', 'bdevs-elementor' ),							]		);		
		$this->add_control(			'image_style_6',			[				'label'   => esc_html__( 'Service Image', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Service Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'image_2_style_6',			[				'label'   => esc_html__( 'Service Image 2', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Service Image', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'shape_image_1_style_6',			[				'label'   => esc_html__( 'Shape Image 1', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Shape Image 1', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'shape_image_2_style_6',			[				'label'   => esc_html__( 'Shape Image 2', 'bdevs-elementor' ),				'type'    => Controls_Manager::MEDIA,				'dynamic' => [ 'active' => true ],				'description' => esc_html__( 'Add Your Shape Image 2', 'bdevs-elementor' ),			]		);		
		$this->add_control(			'heading_style_6',			[				'label'       => __( 'Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);			
		$this->add_control(			'sub_heading_style_6',			[				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),				'type'        => Controls_Manager::TEXT,				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),				'default'     => __( '', 'bdevs-elementor' ),				'label_block' => true,			]		);		
		$this->add_control(			'tabs_style_6',			[				'label' => esc_html__( 'Service Items', 'bdevs-elementor' ),				'type' => Controls_Manager::REPEATER,				'fields' => [						[						'name'    => 'tab_image',						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),						'type'    => Controls_Manager::MEDIA,						'dynamic' => [ 'active' => true ],						'default'     => __( '', 'bdevs-elementor' ),					],					[						'name'        => 'tab_title',						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Title' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_subtitle',						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Service Subtitle' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_icon',						'label'       => esc_html__( 'Icon', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Tab Icon' , 'bdevs-elementor' ),						'label_block' => true,					],					[						'name'        => 'tab_link',						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),						'type'        => Controls_Manager::TEXT,						'dynamic'     => [ 'active' => true ],						'default'     => esc_html__( 'Link' , 'bdevs-elementor' ),						'label_block' => true,					],				],			]		);		
		$this->end_controls_section();		
		$this->start_controls_section(			'section_content_layout',			[				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),			]		);		
		$this->add_responsive_control(			'align',			[				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),				'type'    => Controls_Manager::CHOOSE,				'options' => [					'left' => [						'title' => esc_html__( 'Left', 'bdevs-elementor' ),						'icon'  => 'fa fa-align-left',					],					'center' => [						'title' => esc_html__( 'Center', 'bdevs-elementor' ),						'icon'  => 'fa fa-align-center',					],					'right' => [						'title' => esc_html__( 'Right', 'bdevs-elementor' ),						'icon'  => 'fa fa-align-right',					],					'justify' => [						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),						'icon'  => 'fa fa-align-justify',					],				],				'prefix_class' => 'elementor%s-align-',				'description'  => 'Use align to match position',				'default'      => 'center',			]		);		
		$this->add_control(			'show_heading',			[				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),				'type'    => Controls_Manager::SWITCHER,				'default' => 'yes',			]		);			
		$this->add_control(			'show_sub_heading',			[				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),				'type'    => Controls_Manager::SWITCHER,				'default' => 'yes',			]		);				
		$this->add_control(			'show_image',			[				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),				'type'    => Controls_Manager::SWITCHER,				'default' => 'yes',			]		);		
		$this->add_control(			'show_content',			[				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),				'type'    => Controls_Manager::SWITCHER,				'default' => 'yes',			]		);		
		$this->add_control(			'show_button',			[				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),				'type'    => Controls_Manager::SWITCHER,				'default' => 'yes',			]		);		
		$this->end_controls_section();	}	
	public function render() {		$settings  = 
		$this->get_settings_for_display();		$chose_style = $settings['chose_style'];		?>		
		<?php if( $chose_style == 'service_style_1' ): ?>		<div class="service-area">			<div class="container-fluid px-0">				<div class="row no-gutters">					<?php 					$order = $settings['post_order'];					$post_number = $settings['post_number'];					$wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'service',  'orderby' => 'ID', 'order' => $order));					?>					<?php 					while ($wp_query -> have_posts()) : $wp_query -> the_post(); 						?>						<?php 						$service_excerpt = get_post_meta(get_the_ID(),'_cmb_service_excerpt', true); 						$service_image = get_post_meta(get_the_ID(),'_cmb_service_image', true); 						?> 										<div class="col-xl-3 col-md-6">						<div class="service-wrap">							<div class="service-icon">								<img src="<?php echo wp_get_attachment_url($service_image);?>" alt="icon">							</div>							<div class="service-details">								<h4><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>								<p>									<?php echo esc_attr($service_excerpt); ?>								</p>							</div>							<div class="service-shape"></div>						</div>					</div>					<?php endwhile; ?>				</div>			</div>		</div>		<?php elseif( $chose_style == 'service_style_2' ): ?>						<?php if (( '' !== $settings['image_style_2']['url'] ) && ( $settings['show_image'] )): ?>			<div class="service-area service-area-2 pt-130 pb-130" style="background-image: url(<?php echo wp_kses_post($settings['image_style_2']['url']); ?>)">			<?php endif; ?>				<div class="container">				<div class="row justify-content-center mb-55">					<div class="col-xl-6 col-lg-8 col-md-10">						<div class="section-title text-center">														<?php if (( '' !== $settings['sub_heading_style_2'] ) && ( $settings['show_sub_heading'] )): ?>							<h5><?php echo wp_kses_post($settings['sub_heading_style_2']); ?></h5>							<?php endif; ?>														<?php if (( '' !== $settings['heading_style_2'] ) && ( $settings['show_heading'] )): ?>							<h3><?php echo wp_kses_post($settings['heading_style_2']); ?></h3>							<?php endif; ?>														<?php if ( '' !== $settings['image_2_style_2']['url'] ) : ?>							<div class="icon">								<img src="<?php echo wp_kses_post($settings['image_2_style_2']['url']); ?>" alt="icon">							</div>							<?php endif; ?>							</div>					</div>				</div>				<div class="row">					<?php 					foreach ( $settings['tabs'] as $item ) : ?>					<div class="col-xl-4 col-md-6">						<div class="service-wrap-6">							<div class="service-thumb">								<?php if ( '' !== $item['tab_image']['url'] ) : ?>								<a href="<?php echo wp_kses_post($item['tab_link']); ?>">									<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="service">								</a>								<?php endif; ?>																	<?php if ( '' !== $item['tab_icon'] ) : ?>								<span class="service-icon">									<i class="<?php echo wp_kses_post($item['tab_icon']); ?>"></i>								</span>								<?php endif; ?>								</div>							<div class="service-details">																<?php if ( '' !== $item['tab_title'] ) : ?>								<h4><a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_title']); ?></a></h4>								<?php endif; ?>																	<?php if ( '' !== $item['tab_subtitle'] ) : ?>								<p>									<?php echo wp_kses_post($item['tab_subtitle']); ?>								</p>								<?php endif; ?>																	<?php if ( '' !== $item['tab_link'] ) : ?>								<a href="<?php echo wp_kses_post($item['tab_link']); ?>" class="read-more"><i class="far fa-long-arrow-right"></i></a>								<?php endif; ?>								</div>						</div>					</div>					<?php					endforeach;					?>				</div>			</div>						<?php if ( '' !== $settings['shape_image_1']['url'] ) : ?>			<div class="shape-1">				<img src="<?php echo wp_kses_post($settings['shape_image_1']['url']); ?>" alt="icon">			</div>			<?php endif; ?>							<?php if ( '' !== $settings['shape_image_2']['url'] ) : ?>			<div class="shape-2">				<img src="<?php echo wp_kses_post($settings['shape_image_2']['url']); ?>" alt="icon">			</div>			<?php endif; ?>			</div>	<?php elseif( $chose_style == 'service_style_3' ): ?>		<div class="service-area pt-130 pb-100">		<div class="container">			<div class="row align-items-center">				<div class="col-xl-5">					<div class="section-title">						<?php if (( '' !== $settings['sub_heading_style_3'] ) && ( $settings['show_sub_heading'] )): ?>							<h5><?php echo wp_kses_post($settings['sub_heading_style_3']); ?></h5>							<?php endif; ?>								<?php if (( '' !== $settings['heading_style_3'] ) && ( $settings['show_heading'] )): ?>							<h3><?php echo wp_kses_post($settings['heading_style_3']); ?></h3>							<?php endif; ?>								<?php if (( '' !== $settings['image_style_3']['url'] ) && ( $settings['show_image'] )): ?>							<div class="icon">								<img src="<?php echo wp_kses_post($settings['image_style_3']['url']); ?>" alt="icon">							</div>							<?php endif; ?>						</div>										<?php if (( '' !== $settings['content_style_3'] ) && ( $settings['show_content'] )): ?>					<p>						<?php echo wp_kses_post($settings['content_style_3']); ?>					</p>					<?php endif; ?>						<?php if (( '' !== $settings['button_style_3'] ) && ( $settings['show_button'] )): ?>					<a href="<?php echo wp_kses_post($settings['link_style_3']); ?>" class="a-btn btn-theme"><?php echo wp_kses_post($settings['button_style_3']); ?> <i class="fas fa-plus"></i></a>					<?php endif; ?>					</div>				<div class="col-xl-7">					<div class="row">					<?php foreach ( $settings['tabs_style_3'] as $item ) : ?>						<div class="col-xl-6 col-md-6">							<div class="service-wrap-4 <?php echo wp_kses_post($item['tab_shape']); ?>">								<?php if ( '' !== $item['tab_image']['url'] ) : ?>								<div class="service-icon">									<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="icon">								</div>								<?php endif; ?>									<div class="service-details">																		<?php if ( '' !== $item['tab_title'] ) : ?>									<h4><a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_title']); ?></a></h4>									<?php endif; ?>																			<?php if ( '' !== $item['tab_subtitle'] ) : ?>									<p>										<?php echo wp_kses_post($item['tab_subtitle']); ?>									</p>									<?php endif; ?>									</div>							</div>						</div>						<?php					endforeach;					?>					</div>				</div>			</div>		</div>	</div>	<?php elseif( $chose_style == 'service_style_4' ): ?>				<?php if (( '' !== $settings['image_style_4']['url'] ) && ( $settings['show_image'] )): ?>		<div class="service-area-3 pt-130 pb-130" style="background-image: url(<?php echo wp_kses_post($settings['image_style_4']['url']); ?>)">		<?php endif; ?>			<div class="container">			<div class="row justify-content-center mb-55">				<div class="col-xl-6 col-lg-8 col-md-10">					<div class="section-title text-center">						<?php if (( '' !== $settings['sub_heading_style_4'] ) && ( $settings['show_sub_heading'] )): ?>							<h5><?php echo wp_kses_post($settings['sub_heading_style_4']); ?></h5>						<?php endif; ?>							<?php if (( '' !== $settings['heading_style_4'] ) && ( $settings['show_heading'] )): ?>							<h3><?php echo wp_kses_post($settings['heading_style_4']); ?></h3>						<?php endif; ?>							<?php if ( '' !== $settings['icon_image_style_4']['url'] ) : ?>							<div class="icon">								<img src="<?php echo wp_kses_post($settings['icon_image_style_4']['url']); ?>" alt="icon">							</div>						<?php endif; ?>						</div>				</div>			</div>			<div class="row">				<?php foreach ( $settings['tabs_style_4'] as $item ) : ?>				<div class="col-xl-3 col-md-6">					<div class="service-wrap-5">												<?php if ( '' !== $item['tab_image']['url'] ) : ?>						<div class="service-wrap-bg" style="background-image: url(<?php echo wp_kses_post($item['tab_image']['url']); ?>)"></div>						<?php endif; ?>													<?php if ( '' !== $item['tab_icon'] ) : ?>						<div class="service-icon">							<i class="<?php echo wp_kses_post($item['tab_icon']); ?>"></i>						</div>						<?php endif; ?>							<div class="service-details">														<?php if ( '' !== $item['tab_title'] ) : ?>							<h4><a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_title']); ?></a></h4>							<?php endif; ?>															<?php if ( '' !== $item['tab_subtitle'] ) : ?>							<p>								<?php echo wp_kses_post($item['tab_subtitle']); ?>							</p>							<?php endif; ?>															<?php if ( '' !== $item['tab_link'] ) : ?>							<a href="<?php echo wp_kses_post($item['tab_link']); ?>" class="read-more"><i class="fal fa-long-arrow-right"></i></a>							<?php endif; ?>							</div>					</div>				</div>				<?php			endforeach;			?>			</div>		</div>		<?php if ( '' !== $settings['image_2_style_4']['url'] ) : ?>		<div class="service-thumb-1">			<img src="<?php echo wp_kses_post($settings['image_2_style_4']['url']); ?>" alt="thumb">		</div>		<?php endif; ?>		</div>	<?php elseif( $chose_style == 'service_style_5' ): ?>		<div class="service-area pt-100">		<div class="container">			<div class="row align-items-center mb-50">				<div class="col-xl-5">					<div class="section-title mb-20">						<?php if (( '' !== $settings['sub_heading_style_5'] ) && ( $settings['show_sub_heading'] )): ?>							<h5><?php echo wp_kses_post($settings['sub_heading_style_5']); ?></h5>						<?php endif; ?>							<?php if (( '' !== $settings['heading_style_5'] ) && ( $settings['show_heading'] )): ?>							<h3><?php echo wp_kses_post($settings['heading_style_5']); ?></h3>						<?php endif; ?>							<?php if ( '' !== $settings['icon_image_style_5']['url'] ) : ?>							<div class="icon">								<img src="<?php echo wp_kses_post($settings['icon_image_style_5']['url']); ?>" alt="icon">							</div>						<?php endif; ?>						</div>				</div>				<div class="col-xl-7">					<?php if (( '' !== $settings['content_style_5'] ) && ( $settings['show_content'] )): ?>					<p>						<?php echo wp_kses_post($settings['content_style_5']); ?>					</p>					<?php endif; ?>					</div>			</div>			<div class="row mb-100">				<?php foreach ( $settings['tabs_style_5'] as $item ) : ?>				<div class="col-xl-3">					<div class="service-wrap-3 mb-30">						<?php if ( '' !== $item['tab_icon'] ) : ?>						<div class="service-icon">							<i class="<?php echo wp_kses_post($item['tab_icon']); ?>"></i>						</div>						<?php endif; ?>							<div class="service-details">							<?php if ( '' !== $item['tab_title'] ) : ?>							<h4><a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_title']); ?></a></h4>							<?php endif; ?>															<?php if ( '' !== $item['tab_subtitle'] ) : ?>							<p>								<?php echo wp_kses_post($item['tab_subtitle']); ?>							</p>							<?php endif; ?>							</div>					</div>				</div>				<?php			endforeach;			?>							</div>			<div class="row">				<div class="col-xl-12">					<div class="video-wrap mb--160">						<?php if ( '' !== $settings['video_image_style_5']['url'] ) : ?>						<div class="video-thumb">							<img src="<?php echo wp_kses_post($settings['video_image_style_5']['url']); ?>" alt="bg">						</div>						<?php endif; ?>							<div class="video-hover">							<?php if ( '' !== $settings['video_link_style_5'] ) : ?>							<a  href="<?php echo wp_kses_post($settings['video_link_style_5']); ?>" class="play-animation popup-video">								<i class="fas fa-play"></i>								<span class="shape"></span>							</a>							<?php endif; ?>								<?php if ( '' !== $settings['video_title_style_5'] ) : ?>							<h3><?php echo wp_kses_post($settings['video_title_style_5']); ?></h3>							<?php endif; ?>							</div>					</div>				</div>			</div>		</div>	</div>	<?php elseif( $chose_style == 'service_style_6' ): ?>		<?php if (( '' !== $settings['image_style_6']['url'] ) && ( $settings['show_image'] )): ?>		<div class="service-area service-area-2 pt-130 pb-130" style="background-image: url(<?php echo wp_kses_post($settings['image_style_6']['url']); ?>)">			<?php endif; ?>		<div class="container">			<div class="row justify-content-center  mt-130 mb-55">				<div class="col-xl-6 col-lg-8 col-md-10">					<div class="section-title text-center">						<?php if (( '' !== $settings['sub_heading_style_6'] ) && ( $settings['show_sub_heading'] )): ?>							<h5><?php echo wp_kses_post($settings['sub_heading_style_6']); ?></h5>						<?php endif; ?>												<?php if (( '' !== $settings['heading_style_6'] ) && ( $settings['show_heading'] )): ?>							<h3><?php echo wp_kses_post($settings['heading_style_6']); ?></h3>						<?php endif; ?>												<?php if ( '' !== $settings['image_2_style_6']['url'] ) : ?>							<div class="icon">								<img src="<?php echo wp_kses_post($settings['image_2_style_6']['url']); ?>" alt="icon">							</div>						<?php endif; ?>						</div>				</div>			</div>			<div class="row">				<?php 					foreach ( $settings['tabs_style_6'] as $item ) : ?>				<div class="col-xl-4 col-md-6">					<div class="service-wrap-2">						<div class="service-thumb">							<?php if ( '' !== $item['tab_image']['url'] ) : ?>								<a href="<?php echo wp_kses_post($item['tab_link']); ?>">									<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="service">								</a>								<?php endif; ?>																	<?php if ( '' !== $item['tab_icon'] ) : ?>								<span class="service-icon">									<i class="<?php echo wp_kses_post($item['tab_icon']); ?>"></i>								</span>								<?php endif; ?>							</div>						<div class="service-details">							<?php if ( '' !== $item['tab_title'] ) : ?>								<h4><a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_title']); ?></a></h4>							<?php endif; ?>								<?php if ( '' !== $item['tab_subtitle'] ) : ?>								<p>									<?php echo wp_kses_post($item['tab_subtitle']); ?>								</p>							<?php endif; ?>								<?php if ( '' !== $item['tab_link'] ) : ?>								<a href="<?php echo wp_kses_post($item['tab_link']); ?>" class="read-more"><i class="far fa-long-arrow-right"></i></a>							<?php endif; ?>							</div>					</div>				</div>				<?php					endforeach;					?>			</div>		</div>		<?php if ( '' !== $settings['shape_image_1_style_6']['url'] ) : ?>			<div class="shape-1">				<img src="<?php echo wp_kses_post($settings['shape_image_1_style_6']['url']); ?>" alt="icon">			</div>		<?php endif; ?>			<?php if ( '' !== $settings['shape_image_2_style_6']['url'] ) : ?>			<div class="shape-2">				<img src="<?php echo wp_kses_post($settings['shape_image_2_style_6']['url']); ?>" alt="icon">			</div>		<?php endif; ?>		</div>	<?php endif; ?>		<?php	}}