<?php

namespace BdevsElementor\Widget;



use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;

use Elementor\Scheme_Typography;

use Elementor\Group_Control_Border;

use Elementor\Group_Control_Box_Shadow;



/**

 * Bdevs Elementor Widget.

 *

 * Elementor widget that inserts an embbedable content into the page, from any given URL.

 *

 * @since 1.0.0

 */

class BdevsChoose extends \Elementor\Widget_Base {



	/**

	 * Get widget name.

	 *

	 * Retrieve Bdevs Elementor widget name.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget name.

	 */

	public function get_name() {

		return 'bdevs-choose';

	}



	/**

	 * Get widget title.

	 *

	 * Retrieve Bdevs Elementor widget title.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget title.

	 */

	public function get_title() {

		return __( 'Choose Widget', 'bdevs-elementor' );

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve Bdevs Slider widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-favorite';

	}



	/**

	 * Get widget categories.

	 *

	 * Retrieve the list of categories the Bdevs Slider widget belongs to.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return array Widget categories.

	 */

	public function get_categories() {

		return [ 'bdevs-elementor' ];

	}



	public function get_keywords() {

		return [ 'bdevs-choose' ];

	}



	public function get_script_depends() {

		return [ 'bdevs-elementor'];

	}



	// BDT Position

	protected function element_pack_position() {

	    $position_options = [

	        ''              => esc_html__('Default', 'bdevs-elementor'),

	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,

	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,

	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,

	        'center'        => esc_html__('Center', 'bdevs-elementor') ,

	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,

	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,

	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,

	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,

	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,

	    ];



	    return $position_options;

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section_content_choose',

			[

				'label' => esc_html__( 'Why Choose Us', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'chose_style',

			[

				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'choose_style_1'  => esc_html__( 'Choose Style 1', 'bdevs-elementor' ),

					'choose_style_2' => esc_html__( 'Choose Style 2', 'bdevs-elementor' ),

					'choose_style_3' => esc_html__( 'Choose Style 3', 'bdevs-elementor' ),

				],

				'default'   => 'choose_style_1',

			]

		);



		$this->add_control(

			'icon_image',

			[

				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'content',

			[

				'label'       => __( 'Content', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXTAREA,

				'placeholder' => __( 'Enter your content', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'button_link',

			[

				'label'       => __( 'Button Link', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your button link', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'button',

			[

				'label'       => __( 'Button', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your button', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'tabs',

			[

				'label' => esc_html__( 'Choose Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [			

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Tab Title' , 'bdevs-elementor' ),

						'label_block' => true,

					],



					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXTAREA,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Subtitle' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'       => 'tab_icon',

						'label'      => esc_html__( 'Tab Icon', 'bdevs-elementor' ),

						'type'       => Controls_Manager::TEXT,

						'dynamic'    => [ 'active' => true ],

						'default'    => esc_html__( '', 'bdevs-elementor' ),

					],

					[

						'name'        => 'tab_bottom',

						'label'       => esc_html__( 'Tab Bottom', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( '' , 'bdevs-elementor' ),

					],

				],

			]

		);



		$this->end_controls_section();





		$this->start_controls_section(

			'section_content_choose_2',

			[

				'label' => esc_html__( 'Choose Style 2', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'icon_image_style_2',

			[

				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading_style_2',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading_style_2',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'tabs_2',

			[

				'label' => esc_html__( 'Choose Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [	

					[

						'name'    => 'tab_image',

						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),

						'type'    => Controls_Manager::MEDIA,

						'dynamic' => [ 'active' => true ],
						'default'     => __( '', 'bdevs-elementor' ),

					],		

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Tab Title' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXTAREA,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Subtitle' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'       => 'tab_link',

						'label'      => esc_html__( 'Tab Link', 'bdevs-elementor' ),

						'type'       => Controls_Manager::TEXT,

						'dynamic'    => [ 'active' => true ],

						'default'    => esc_html__( '', 'bdevs-elementor' ),

					],

					

				],

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_choose_3',

			[

				'label' => esc_html__( 'Choose Style 3', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'image_style_3',

			[

				'label'   => esc_html__( 'Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'thumb_image_style_3',

			[

				'label'   => esc_html__( 'Thumb Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Thumb Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'icon_image_style_3',

			[

				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading_style_3',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading_style_3',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'tabs_3',

			[

				'label' => esc_html__( 'Choose Items', 'bdevs-elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => [			

					[

						'name'        => 'tab_title',

						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXT,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Tab Title' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'        => 'tab_subtitle',

						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),

						'type'        => Controls_Manager::TEXTAREA,

						'dynamic'     => [ 'active' => true ],

						'default'     => esc_html__( 'Subtitle' , 'bdevs-elementor' ),

						'label_block' => true,

					],

					[

						'name'       => 'tab_icon',

						'label'      => esc_html__( 'Tab Icon', 'bdevs-elementor' ),

						'type'       => Controls_Manager::TEXT,

						'dynamic'    => [ 'active' => true ],

						'default'    => esc_html__( '', 'bdevs-elementor' ),

					],

					

				],

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_layout',

			[

				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),

			]

		);



		$this->add_responsive_control(

			'align',

			[

				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),

				'type'    => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => esc_html__( 'Left', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-left',

					],

					'center' => [

						'title' => esc_html__( 'Center', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-center',

					],

					'right' => [

						'title' => esc_html__( 'Right', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-right',

					],

					'justify' => [

						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-justify',

					],

				],

				'prefix_class' => 'elementor%s-align-',

				'description'  => 'Use align to match position',

				'default'      => 'center',

			]

		);





		$this->add_control(

			'show_heading',

			[

				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);	



		$this->add_control(

			'show_sub_heading',

			[

				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);		



		$this->add_control(

			'show_image',

			[

				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);



		$this->add_control(

			'show_content',

			[

				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);
		$this->add_control(

			'show_button',

			[

				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);



		$this->end_controls_section();







	}



	public function render() {

		$settings  = $this->get_settings_for_display();

		$chose_style = $settings['chose_style'];

		?>

		

		<?php if( $chose_style == 'choose_style_1' ): ?>



		<div class="choose-us-area choose-us-area-3">



			<div class="choose-us-bg">



				<div class="container">



					<div class="row">



						<div class="col-xl-6 col-lg-6">



							<div class="choose-us-wrap choose-us-wrap-3">



								<div class="section-title mb-20">

									

									<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>

									<h5><?php echo wp_kses_post($settings['sub_heading']); ?></h5>

									<?php endif; ?>

									

									<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>

									<h3><?php echo wp_kses_post($settings['heading']); ?></h3>

									<?php endif; ?>



									<?php if (( '' !== $settings['icon_image']['url'] ) && ( $settings['show_image'] )): ?>

									<div class="icon">

										<img src="<?php echo wp_kses_post($settings['icon_image']['url']); ?>" alt="icon">

									</div>

									<?php endif; ?>



								</div>

								

								<?php if (( '' !== $settings['content'] ) && ( $settings['show_content'] )): ?>

								<p>

									<?php echo wp_kses_post($settings['content']); ?>

								</p>

								<?php endif; ?>

								

								<?php if (( '' !== $settings['button'] ) && ( $settings['show_button'] )): ?>

								<a href="<?php echo wp_kses_post($settings['button_link']); ?>" class="b-btn">

									<?php echo wp_kses_post($settings['button']); ?>

									<i class="fas fa-plus"></i>

								</a>

								<?php endif; ?>



							</div>



						</div>



						<div class="col-xl-5 offset-xl-1 col-lg-6 mt-md-50 mt-xs-50 align-self-center">



							<?php foreach ( $settings['tabs'] as $item ) : ?>



							<div class="choose-us-list choose-us-list-3 <?php echo wp_kses_post($item['tab_bottom']); ?>">

								

								<?php if ( '' !== $item['tab_icon'] ): ?>

								<div class="choose-list-icon">

											

									<div class="icon">



										<i class="<?php echo wp_kses_post($item['tab_icon']); ?>"></i>



									</div>



								</div>

								<?php endif; ?>



								<div class="choose-list-details">

									

									<?php if ( '' !== $item['tab_title'] ): ?>

									<h4><?php echo wp_kses_post($item['tab_title']); ?></h4>

									<?php endif; ?>

									

									<?php if ( '' !== $item['tab_subtitle'] ): ?>

									<p><?php echo wp_kses_post($item['tab_subtitle']); ?></p>

									<?php endif; ?>



								</div>



							</div>

							

							<?php endforeach; ?>



						</div>



					</div>



				</div>



			</div>



		</div>



		<?php elseif( $chose_style == 'choose_style_2' ): ?>



			<div class="approch-area pt-130 pb-100">

				<div class="container">

					<div class="row justify-content-center">

						<div class="col-xl-6">

							<div class="section-title text-center section-title-white mb-50">

								<?php if (( '' !== $settings['sub_heading_style_2'] ) && ( $settings['show_sub_heading'] )): ?>

								<h5><?php echo wp_kses_post($settings['sub_heading_style_2']); ?></h5>

							<?php endif; ?>



							<?php if (( '' !== $settings['heading_style_2'] ) && ( $settings['show_heading'] )): ?>

							<h3><?php echo wp_kses_post($settings['heading_style_2']); ?></h3>

						<?php endif; ?>



						<?php if (( '' !== $settings['icon_image_style_2']['url'] ) && ( $settings['show_image'] )): ?>

						<div class="icon">

							<img src="<?php echo wp_kses_post($settings['icon_image_style_2']['url']); ?>" alt="icon">

						</div>

					<?php endif; ?>

				</div>

			</div>

		</div>

		<div class="row">



			<?php foreach ( $settings['tabs_2'] as $item ) : ?>



				<div class="col-xl-4">

					<div class="approch-wrap">

						<div class="approch-thumb">

							<?php if ( '' !== $item['tab_image']['url'] ) : ?>

								<a href="<?php echo wp_kses_post($item['tab_link']); ?>">

									<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="thumb">

								</a>

							<?php endif; ?>

						</div>

						<div class="approch-details">

							<?php if ( '' !== $item['tab_title'] ): ?>

								<h4><a href="<?php echo wp_kses_post($item['tab_link']); ?>"><?php echo wp_kses_post($item['tab_title']); ?></a></h4>

							<?php endif; ?>

							<?php if ( '' !== $item['tab_subtitle'] ): ?>

								<p><?php echo wp_kses_post($item['tab_subtitle']); ?></p>

							<?php endif; ?>

							<?php if ( '' !== $item['tab_link'] ): ?>

								<a href="<?php echo wp_kses_post($item['tab_link']); ?>" class="read-more">

									<i class="far fa-long-arrow-right"></i>

								</a>

							<?php endif; ?>

						</div>

					</div>

				</div>

			<?php endforeach; ?>

		</div>

	</div>

</div>



	<?php elseif( $chose_style == 'choose_style_3' ): ?>



		<?php if (( '' !== $settings['image_style_3']['url'] ) && ( $settings['show_image'] )): ?>

		<div class="choose-area-2 pt-130 pb-100" style="background-image: url(<?php echo wp_kses_post($settings['image_style_2']['url']); ?>)">

		<?php endif; ?>



		<div class="container">



			<div class="row justify-content-center align-items-center">



				<div class="col-xl-5 col-lg-6 col-md-8 col-10">



					<?php if ( '' !== $settings['thumb_image_style_3']['url'] ) : ?>

					<div class="choose-us-thumb">



						<img src="<?php echo wp_kses_post($settings['thumb_image_style_3']['url']); ?>" alt="thumb">



					</div>

					<?php endif; ?>



				</div>



				<div class="col-xl-5 offset-xl-1 col-lg-6 mt-md-50 mt-xs-50 align-self-center">



					<div class="section-title mb-35">



						<?php if (( '' !== $settings['sub_heading_style_3'] ) && ( $settings['show_sub_heading'] )): ?>

							<h5><?php echo wp_kses_post($settings['sub_heading_style_3']); ?></h5>

							<?php endif; ?>

							

							<?php if (( '' !== $settings['heading_style_3'] ) && ( $settings['show_heading'] )): ?>

							<h3><?php echo wp_kses_post($settings['heading_style_3']); ?></h3>

							<?php endif; ?>

							

							<?php if ( '' !== $settings['icon_image_style_3']['url'] ) : ?>

							<div class="icon">

								<img src="<?php echo wp_kses_post($settings['icon_image_style_3']['url']); ?>" alt="icon">

							</div>

							<?php endif; ?>	



					</div>



					<?php 

					foreach ( $settings['tabs_3'] as $item ) : ?>



					<div class="choose-us-list-2 mb-35">



						<?php if ( '' !== $item['tab_icon'] ) : ?>



						<div class="choose-list-icon">



							<div class="icon">



								<i class="<?php echo wp_kses_post($item['tab_icon']); ?>"></i>



							</div>



						</div>



						<?php endif; ?>	



						<div class="choose-list-details">



							<?php if ( '' !== $item['tab_title'] ) : ?>

								<h4><?php echo wp_kses_post($item['tab_title']); ?></h4>

								<?php endif; ?>	

								

								<?php if ( '' !== $item['tab_subtitle'] ) : ?>

								<p>

									<?php echo wp_kses_post($item['tab_subtitle']); ?>

								</p>

								<?php endif; ?>	



						</div>



					</div>



					<?php

					endforeach;

					?>



				</div>



			</div>



		</div>



	</div>





<?php endif; ?>



	<?php

	}



}