<?php

namespace BdevsElementor\Widget;



use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;

use Elementor\Scheme_Typography;

use Elementor\Group_Control_Border;

use Elementor\Group_Control_Box_Shadow;



/**

 * Bdevs Elementor Widget.

 *

 * Elementor widget that inserts an embbedable content into the page, from any given URL.

 *

 * @since 1.0.0

 */

class BdevsGallery extends \Elementor\Widget_Base {



	/**

	 * Get widget name.

	 *

	 * Retrieve Bdevs Elementor widget name.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget name.

	 */

	public function get_name() {

		return 'bdevs-gallery';

	}



	/**

	 * Get widget title.

	 *

	 * Retrieve Bdevs Elementor widget title.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget title.

	 */

	public function get_title() {

		return __( 'Gallery Widget', 'bdevs-elementor' );

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve Bdevs Slider widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-favorite';

	}



	/**

	 * Get widget categories.

	 *

	 * Retrieve the list of categories the Bdevs Slider widget belongs to.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return array Widget categories.

	 */

	public function get_categories() {

		return [ 'bdevs-elementor' ];

	}



	public function get_keywords() {

		return [ 'bdevs-gallery' ];

	}



	public function get_script_depends() {

		return [ 'bdevs-elementor'];

	}



	// BDT Position

	protected function element_pack_position() {

	    $position_options = [

	        ''              => esc_html__('Default', 'bdevs-elementor'),

	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,

	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,

	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,

	        'center'        => esc_html__('Center', 'bdevs-elementor') ,

	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,

	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,

	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,

	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,

	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,

	    ];



	    return $position_options;

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section_content_gallery',

			[

				'label' => esc_html__( 'Gallery Area', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'icon_image',

			[

				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'post_number',

			[

				'label'       => __( 'Post Number', 'bdevs-elementor' ),

				'type'        => Controls_Manager::NUMBER,

				'default'     => __( '7', 'bdevs-elementor' ),

			]

		);	

		$this->add_control(

			'post_order',

			[

				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),

					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),

				],

				'default'   => 'asc',

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_layout',

			[

				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),

			]

		);



		$this->add_responsive_control(

			'align',

			[

				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),

				'type'    => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => esc_html__( 'Left', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-left',

					],

					'center' => [

						'title' => esc_html__( 'Center', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-center',

					],

					'right' => [

						'title' => esc_html__( 'Right', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-right',

					],

					'justify' => [

						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-justify',

					],

				],

				'prefix_class' => 'elementor%s-align-',

				'description'  => 'Use align to match position',

				'default'      => 'center',

			]

		);



		$this->add_control(

			'show_heading',

			[

				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);	



		$this->add_control(

			'show_sub_heading',

			[

				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);		



		$this->add_control(

			'show_image',

			[

				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);



		$this->end_controls_section();







	}



	public function render() {

		$settings  = $this->get_settings_for_display();

		?>

		

		<div class="photo-gallery-area gallery-filter-wrapper pt-30 pb-100">



			<div class="container">



				<div class="row justify-content-center mb-20">



					<div class="col-xl-6 col-lg-8 col-md-10">



						<div class="section-title text-center">

							

							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>

							<h5><?php echo wp_kses_post($settings['sub_heading']); ?></h5>

							<?php endif; ?>

							

							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>

							<h3><?php echo wp_kses_post($settings['heading']); ?></h3>

							<?php endif; ?>

							

							<?php if (( '' !== $settings['icon_image']['url'] ) && ( $settings['show_image'] )): ?>

							<div class="icon">



								<img src="<?php echo wp_kses_post($settings['icon_image']['url']); ?>" alt="icon">



							</div>

							<?php endif; ?>



						</div>



					</div>



				</div>



				<div class="row mb-60">



					<div class="col-xl-12">



						<div class="gallery-filter-nav">



							<button class="active" data-filter="*"><?php echo esc_html__( 'Show All', 'fudee' ); ?></button>



							<?php  $categories = get_terms('type1'); 



                                foreach( (array)$categories as $categorie){



                                    $cat_name = $categorie->name; 



                                    $cat_slug = $categorie->slug;



                                    ?>



							<button data-filter=".<?php echo $cat_slug ?>"><?php echo $cat_name ?></button>



							<?php } ?>



						</div>



					</div>



				</div>



			</div>



			<div class="container-fluid gallery-filter-space">



				<div class="row gallery-filter-grid">



					<?php 

					$order = $settings['post_order'];

					$post_number = $settings['post_number'];

					$wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'gallery',  'orderby' => 'ID', 'order' => $order));

					?>

					<?php 

					$i = 0;

					while ($wp_query -> have_posts()) : $wp_query -> the_post(); 

						$cates = get_the_terms(get_the_ID(),'type1');

						$cate_name ='';

						$cate_slug ='';

						foreach((array)$cates as $cate){

							if(count($cates)>0){

								$cate_name .= $cate->name.' ';

								$cate_slug .= $cate->slug.' ';      

							} 

						} 

						$i++;



						$gallery_area_image = get_post_meta(get_the_ID(),'_cmb_gallery_area_image', true);

						$gallery_type_2 = get_post_meta(get_the_ID(),'_cmb_gallery_type_2', true);



						?> 

						<?php if($i =='5') { ?>



							<div class="col-xl-6 col-md-6 grid-item <?php echo $cate_slug ?>">



								<div class="photo-gallery-wrap mb-30">



									<div class="gallery-thumb gallery-thumb-2">



										<img src="<?php echo wp_get_attachment_url($gallery_area_image);?>" alt="gallery">



									</div>



									<div class="gallery-details">



										<h4><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>



										<span class="cat"><a href="<?php the_permalink();?>"><?php echo esc_attr($gallery_type_2); ?></a></span>



										<a href="<?php the_permalink();?>" class="read-more"><i class="far fa-long-arrow-right"></i></a>



									</div>



								</div>



							</div>



						<?php } else { ?>



							<div class="col-xl-3 col-md-6 grid-item <?php echo $cate_slug ?>">



								<div class="photo-gallery-wrap mb-30">



									<div class="gallery-thumb gallery-thumb-2">



										<img src="<?php echo wp_get_attachment_url($gallery_area_image);?>" alt="gallery">



									</div>



									<div class="gallery-details">



										<h4><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>



										<span class="cat"><a href="<?php the_permalink();?>"><?php echo esc_attr($gallery_type_2); ?></a></span>



										<a href="<?php the_permalink();?>" class="read-more"><i class="far fa-long-arrow-right"></i></a>



									</div>



								</div>



							</div>

						<?php } ?>

					<?php endwhile; ?>



				</div>



			</div>



		</div>



	<?php

	}



}