<?php

namespace BdevsElementor\Widget;



use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;

use Elementor\Scheme_Typography;

use Elementor\Group_Control_Border;

use Elementor\Group_Control_Box_Shadow;



/**

 * Bdevs Elementor Widget.

 *

 * Elementor widget that inserts an embbedable content into the page, from any given URL.

 *

 * @since 1.0.0

 */

class BdevsCta extends \Elementor\Widget_Base {



	/**

	 * Get widget name.

	 *

	 * Retrieve Bdevs Elementor widget name.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget name.

	 */

	public function get_name() {

		return 'bdevs-cta';

	}



	/**

	 * Get widget title.

	 *

	 * Retrieve Bdevs Elementor widget title.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget title.

	 */

	public function get_title() {

		return __( 'Cta Widget', 'bdevs-elementor' );

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve Bdevs Slider widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-favorite';

	}



	/**

	 * Get widget categories.

	 *

	 * Retrieve the list of categories the Bdevs Slider widget belongs to.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return array Widget categories.

	 */

	public function get_categories() {

		return [ 'bdevs-elementor' ];

	}



	public function get_keywords() {

		return [ 'bdevs-cta' ];

	}



	public function get_script_depends() {

		return [ 'bdevs-elementor'];

	}



	// BDT Position

	protected function element_pack_position() {

	    $position_options = [

	        ''              => esc_html__('Default', 'bdevs-elementor'),

	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,

	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,

	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,

	        'center'        => esc_html__('Center', 'bdevs-elementor') ,

	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,

	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,

	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,

	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,

	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,

	    ];



	    return $position_options;

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section_content_cta',

			[

				'label' => esc_html__( 'Call To Action', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'chose_style',

			[

				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'cta_style_1'  => esc_html__( 'Call To Action Style 1', 'bdevs-elementor' ),

					'cta_style_2' => esc_html__( 'Call To Action Style 2', 'bdevs-elementor' ),

					'cta_style_3' => esc_html__( 'Call To Action Style 3', 'bdevs-elementor' ),

				],

				'default'   => 'cta_style_1',

			]

		);



		$this->add_control(

			'image',

			[

				'label'   => esc_html__( 'Cta Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Cta Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'cta_cat',

			[

				'label'       => __( 'Cta Category', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your cta category', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'heading',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'cta_link',

			[

				'label'       => __( 'Cta Link', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your cta link', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'button',

			[

				'label'       => __( 'Button', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your button', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'video_link',

			[

				'label'       => __( 'Video Link', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your video link', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'video_text',

			[

				'label'       => __( 'Video Text', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your video text', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_cta_2',

			[

				'label' => esc_html__( 'Call To Action Style 2', 'bdevs-elementor' ),

				

			]

		);



		$this->add_control(

			'image_style_2',

			[

				'label'   => esc_html__( 'Cta Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Cta Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'image_2_style_2',

			[

				'label'   => esc_html__( 'Cta Image 2', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Cta Image 2', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading_style_2',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading_style_2',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'content_style_2',

			[

				'label'       => __( 'Content', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXTAREA,

				'placeholder' => __( 'Enter your content', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'link_style_2',

			[

				'label'       => __( 'Link', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your link', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'link_2_style_2',

			[

				'label'       => __( 'Button Link', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your button link', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'button_style_2',

			[

				'label'       => __( 'Button', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your button', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_cta_3',

			[

				'label' => esc_html__( 'Call To Action Style 3', 'bdevs-elementor' ),

				

			]

		);



		$this->add_control(

			'image_style_3',

			[

				'label'   => esc_html__( 'Cta Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Cta Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'image_2_style_3',

			[

				'label'   => esc_html__( 'Cta Image 2', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Cta Image 2', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading_style_3',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	





		$this->add_control(

			'content_style_3',

			[

				'label'       => __( 'Content', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXTAREA,

				'placeholder' => __( 'Enter your content', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'link_style_3',

			[

				'label'       => __( 'Link', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your link', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->add_control(

			'button_style_3',

			[

				'label'       => __( 'Button', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your button', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);



		$this->end_controls_section();











		$this->start_controls_section(

			'section_content_layout',

			[

				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),

			]

		);



		$this->add_responsive_control(

			'align',

			[

				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),

				'type'    => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => esc_html__( 'Left', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-left',

					],

					'center' => [

						'title' => esc_html__( 'Center', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-center',

					],

					'right' => [

						'title' => esc_html__( 'Right', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-right',

					],

					'justify' => [

						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-justify',

					],

				],

				'prefix_class' => 'elementor%s-align-',

				'description'  => 'Use align to match position',

				'default'      => 'center',

			]

		);



		$this->add_control(

			'show_image',

			[

				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);



		$this->add_control(

			'show_heading',

			[

				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);	



		$this->add_control(

			'show_sub_heading',

			[

				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);	



		$this->add_control(

			'show_content',

			[

				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);



		$this->add_control(

			'show_button',

			[

				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);



		$this->end_controls_section();







	}



	public function render() {

		$settings  = $this->get_settings_for_display();

		$chose_style = $settings['chose_style'];

		?>

		

		<?php if( $chose_style == 'cta_style_1' ): ?>



		<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>

		<div class="cta-area cta-area-3" style="background-image: url(<?php echo wp_kses_post($settings['image']['url']); ?>)">

		<?php endif; ?>



			<div class="container">



				<div class="row">



					<div class="col-xl-7 col-lg-9">



						<div class="cta-text cta-text-4">

							

							<?php if ( '' !== $settings['cta_cat'] ) : ?>

							<div class="cta-cat">

								<a href="<?php echo wp_kses_post($settings['cta_link']); ?>"><?php echo wp_kses_post($settings['cta_cat']); ?></a>

							</div>

							<?php endif; ?>



							<div class="cta-content">

								

								<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>

								<h4><?php echo wp_kses_post($settings['heading']); ?></h4>

								<?php endif; ?>



								<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>

								<p>

									<?php echo wp_kses_post($settings['sub_heading']); ?>

								</p>

								<?php endif; ?>



							</div>



							<div class="cta-btn">

								<?php if (( '' !== $settings['button'] ) && ( $settings['show_button'] )): ?>

								<a href="<?php echo wp_kses_post($settings['cta_link']); ?>" class="a-btn" tabindex="0">

									<?php echo wp_kses_post($settings['button']); ?> <i class="fas fa-plus"></i>

								</a>

								<?php endif; ?>

								

								

								<a href="<?php echo wp_kses_post($settings['video_link']); ?>" class="play-btn popup-video">



									<span><?php echo wp_kses_post($settings['video_text']); ?></span>



									<i class="far fa-play"></i>



								</a>

								



							</div>



						</div>



					</div>



				</div>



			</div>



		</div>



		<?php elseif( $chose_style == 'cta_style_2' ): ?>

			

			<?php if (( '' !== $settings['image_style_2']['url'] ) && ( $settings['show_image'] )): ?>

			<div class="cta-area-3 pt-130 pb-130 bg-fix" style="background-image: url(<?php echo wp_kses_post($settings['image_style_2']['url']); ?>)">

			<?php endif; ?>	



				<div class="container">



					<div class="row justify-content-end">



						<div class="col-xl-7 col-lg-9">



							<div class="cta-text-3">

								

								<?php if (( '' !== $settings['sub_heading_style_2'] ) && ( $settings['show_sub_heading'] )): ?>

								<div class="cta-cat">



									<a href="<?php echo wp_kses_post($settings['link_1_style_2']); ?>"><?php echo wp_kses_post($settings['sub_heading_style_2']); ?></a>



								</div>

								<?php endif; ?>



								<div class="cta-content">

									

									<?php if (( '' !== $settings['heading_style_2'] ) && ( $settings['show_heading'] )): ?>

									<h4><?php echo wp_kses_post($settings['heading_style_2']); ?></h4>

									<?php endif; ?>

									

									<?php if (( '' !== $settings['content_style_2'] ) && ( $settings['show_content'] )): ?>

									<p>



										<?php echo wp_kses_post($settings['content_style_2']); ?>



									</p>

									<?php endif; ?>

									

									<?php if (( '' !== $settings['button_style_2'] ) && ( $settings['show_button'] )): ?>

									<a href="<?php echo wp_kses_post($settings['link_2_style_2']); ?>" class="a-btn"><?php echo wp_kses_post($settings['button_style_2']); ?> <i class="fas fa-plus"></i></a>

									<?php endif; ?>



								</div>



							</div>



						</div>



					</div>



				</div>

				

				<?php if ( '' !== $settings['image_2_style_2']['url'] ) : ?>

				<div class="cta-thumb-1">



					<img src="<?php echo wp_kses_post($settings['image_2_style_2']['url']); ?>" alt="thumb">



				</div>

				<?php endif; ?>



			</div>



		<?php elseif( $chose_style == 'cta_style_3' ): ?>



			<div class="cta-area-2 pb-100">



				<div class="container">



					<div class="row">



						<div class="col-xl-12">



							<?php if (( '' !== $settings['image_style_3']['url'] ) && ( $settings['show_image'] )): ?>

							<div class="cta-wrapper-2" style="background-image:url(<?php echo wp_kses_post($settings['image_style_3']['url']); ?>)">

							<?php endif; ?>	



							<div class="row align-items-center">



								<div class="col-xl-8 col-lg-8 col-md-8">



									<div class="cta-text-2">



										<?php if ( '' !== $settings['image_2_style_3']['url'] ): ?>



											<div class="cta-img">



												<img src="<?php echo wp_kses_post($settings['image_2_style_3']['url']); ?>" alt="shape">



											</div>



										<?php endif; ?>	



										<div class="cta-content">



											<?php if (( '' !== $settings['heading_style_3'] ) && ( $settings['show_heading'] )): ?>

											<h3><?php echo wp_kses_post($settings['heading_style_3']); ?></h3>

										<?php endif; ?>



										<?php if (( '' !== $settings['content_style_3'] ) && ( $settings['show_content'] )): ?>

										<p>



											<?php echo wp_kses_post($settings['content_style_3']); ?>



										</p>

									<?php endif; ?>



								</div>



							</div>



						</div>	



						<?php if (( '' !== $settings['button_style_3'] ) && ( $settings['show_button'] )): ?>



						<div class="col-xl-4 col-lg-4 col-md-4">



							<div class="cta-button">



								<a class="a-btn" href="<?php echo wp_kses_post($settings['link_style_3']); ?>"><?php echo wp_kses_post($settings['button_style_3']); ?></a>



							</div>



						</div>



					<?php endif; ?>



				</div>



			</div>



		</div>



	</div>



</div>



</div>



		<?php endif; ?>	



	<?php

	}



}