<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsCounter extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-counter';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Counter Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'bdevs-counter' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_counter',
			[
				'label' => esc_html__( 'Counter Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'counter_style_1'  => esc_html__( 'Counter Style 1', 'bdevs-elementor' ),
					'counter_style_2' => esc_html__( 'Counter Style 2', 'bdevs-elementor' ),
					'counter_style_3' => esc_html__( 'Counter Style 3', 'bdevs-elementor' ),
				],
				'default'   => 'counter_style_1',
			]
		);

		$this->add_control(
			'image',
			[
				'label'   => esc_html__( 'Counter Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Counter Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'video_link',
			[
				'label'       => __( 'Video Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your video link', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( '', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Counter Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_number',
						'label'       => esc_html__( 'Tab Number', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Number' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_counter_2',
			[
				'label' => esc_html__( 'Counter Style 2', 'bdevs-elementor' ),
				
			]
		);

		$this->add_control(
			'tabs_2',
			[
				'label' => esc_html__( 'Counter Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Service Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Service Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_number',
						'label'       => esc_html__( 'Tab Number', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_color',
						'label'       => esc_html__( 'Tab Color', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_counter_3',
			[
				'label' => esc_html__( 'Counter Style 3', 'bdevs-elementor' ),
				
			]
		);

		$this->add_control(
			'image_style_3',
			[
				'label'   => esc_html__( 'Counter Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Counter Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs_3',
			[
				'label' => esc_html__( 'Counter Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Counter Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Counter Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_number',
						'label'       => esc_html__( 'Tab Number', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_color',
						'label'       => esc_html__( 'Tab Color', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();



	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		$chose_style = $settings['chose_style'];
		?>
		
		<?php if( $chose_style == 'counter_style_1' ): ?>

		<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>
		<div class="counter-area counter-area-3 pt-120 bg-fix" style="background-image: url(<?php echo wp_kses_post($settings['image']['url']); ?>)">
		<?php endif; ?>

			<div class="container">

				<div class="row justify-content-center align-items-center">
					<div class="col-xl-5 col-lg-6 col-md-8">
						<div class="counter-details counter-details-2 text-center">
							<?php if ( '' !== $settings['video_link'] ) : ?>
							<a href="<?php echo wp_kses_post($settings['video_link']); ?>" class="play-animation popup-video">
								<i class="fas fa-play"></i>
								<span class="shape"></span>
							</a>
							<?php endif; ?>
							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
							<h3><?php echo wp_kses_post($settings['heading']); ?></h3>
							<?php endif; ?>
						</div>
					</div>
				</div>

				<div class="row mt-xl-5">
					<div class="col-xl-12">
						<div class="counter-wrapper row">

							<?php foreach ( $settings['tabs'] as $item ) : ?>
							
							<div class="col-xl-3 col-md-6">

								<div class="counter-wrap mb-30">
									
									<?php if ( '' !== $item['tab_number'] ) : ?>
									<h4><?php echo wp_kses_post($item['tab_number']); ?></h4>
									<?php endif; ?>
									
									<?php if ( '' !== $item['tab_title'] ) : ?>
									<p><?php echo wp_kses_post($item['tab_title']); ?></p>
									<?php endif; ?>

								</div>

							</div>
							
							<?php endforeach; ?>
							
						</div>
					</div>
				</div>

			</div>

		</div>

		<?php elseif( $chose_style == 'counter_style_2' ): ?>

			<div class="counter-area-2 pt-130 pb-100">

				<div class="container">

					<div class="row">

						<?php foreach ( $settings['tabs_2'] as $item ) : ?>

							<div class="col-xl-3 col-md-6">

								<div class="progress-circular text-white">

									<?php if ( '' !== $item['tab_number'] ) : ?>

									<input type="text" class="knob" value="0" data-rel="<?php echo wp_kses_post($item['tab_number']); ?>" data-linecap="round"

									data-width="200" data-bgcolor="#404b58" data-fgcolor="<?php echo wp_kses_post($item['tab_color']); ?>" data-thickness=".12"

									data-readonly="true" disabled/>

									<?php endif; ?>
									
									<?php if ( '' !== $item['tab_title'] ) : ?>
									<h4><?php echo wp_kses_post($item['tab_title']); ?></h4>
									<?php endif; ?>
									
									<?php if ( '' !== $item['tab_subtitle'] ) : ?>
									<p>

										<?php echo wp_kses_post($item['tab_subtitle']); ?>

									</p>
									<?php endif; ?>

								</div>

							</div>

						<?php endforeach; ?>

					</div>

				</div>

			</div>

		<?php elseif( $chose_style == 'counter_style_3' ): ?>
		
			<?php if (( '' !== $settings['image_style_3']['url'] ) && ( $settings['show_image'] )): ?>
			<div class="counter-area pt-130 pb-100 bg-fix" style="background-image: url(<?php echo wp_kses_post($settings['image_style_3']['url']); ?>)">
			<?php endif; ?>	
			<div class="container">
				<div class="row">

					<?php foreach ( $settings['tabs_3'] as $item ) : ?>

						<div class="col-xl-3 col-md-6">
							<div class="progress-circular">
								<?php if ( '' !== $item['tab_number'] ) : ?>
									<input type="text" class="knob" value="0" data-rel="<?php echo wp_kses_post($item['tab_number']); ?>" data-linecap="round"
									data-width="200" data-bgcolor="#ffffff" data-fgcolor="<?php echo wp_kses_post($item['tab_color']); ?>" data-thickness=".12"
									data-readonly="true" disabled/>
								<?php endif; ?>

								<?php if ( '' !== $item['tab_title'] ) : ?>
									<h4><?php echo wp_kses_post($item['tab_title']); ?></h4>
								<?php endif; ?>

								<?php if ( '' !== $item['tab_subtitle'] ) : ?>
									<p>

										<?php echo wp_kses_post($item['tab_subtitle']); ?>

									</p>
								<?php endif; ?>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>

		<?php endif; ?>

	<?php
	}

}