<?php

namespace BdevsElementor\Widget;



use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;

use Elementor\Scheme_Typography;

use Elementor\Group_Control_Border;

use Elementor\Group_Control_Box_Shadow;



/**

 * Bdevs Elementor Widget.

 *

 * Elementor widget that inserts an embbedable content into the page, from any given URL.

 *

 * @since 1.0.0

 */

class BdevsBlog extends \Elementor\Widget_Base {



	/**

	 * Get widget name.

	 *

	 * Retrieve Bdevs Elementor widget name.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget name.

	 */

	public function get_name() {

		return 'bdevs-blog';

	}



	/**

	 * Get widget title.

	 *

	 * Retrieve Bdevs Elementor widget title.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget title.

	 */

	public function get_title() {

		return __( 'Blog Widget', 'bdevs-elementor' );

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve Bdevs Slider widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-favorite';

	}



	/**

	 * Get widget categories.

	 *

	 * Retrieve the list of categories the Bdevs Slider widget belongs to.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return array Widget categories.

	 */

	public function get_categories() {

		return [ 'bdevs-elementor' ];

	}



	public function get_keywords() {

		return [ 'bdevs-blog' ];

	}



	public function get_script_depends() {

		return [ 'bdevs-elementor'];

	}



	// BDT Position

	protected function element_pack_position() {

	    $position_options = [

	        ''              => esc_html__('Default', 'bdevs-elementor'),

	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,

	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,

	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,

	        'center'        => esc_html__('Center', 'bdevs-elementor') ,

	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,

	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,

	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,

	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,

	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,

	    ];



	    return $position_options;

	}



	protected function _register_controls() {

		$this->start_controls_section(

			'section_content_blog',

			[

				'label' => esc_html__( 'Blog Area', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'chose_style',

			[

				'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'blog_style_1'  => esc_html__( 'Blog Style 1', 'bdevs-elementor' ),

					'blog_style_2' => esc_html__( 'Blog Style 2', 'bdevs-elementor' ),

				],

				'default'   => 'blog_style_1',

			]

		);



		$this->add_control(

			'image',

			[

				'label'   => esc_html__( 'Blog Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Blog Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'icon_image',

			[

				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'post_number',

			[

				'label'       => __( 'Post Number', 'bdevs-elementor' ),

				'type'        => Controls_Manager::NUMBER,

				'default'     => __( '6', 'bdevs-elementor' ),

			]

		);	

		$this->add_control(

			'post_order',

			[

				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),

					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),

				],

				'default'   => 'asc',

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_blog_2',

			[

				'label' => esc_html__( 'Blog Area 2', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'icon_image_style_2',

			[

				'label'   => esc_html__( 'Icon Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::MEDIA,

				'dynamic' => [ 'active' => true ],

				'description' => esc_html__( 'Add Your Icon Image', 'bdevs-elementor' ),

			]

		);



		$this->add_control(

			'heading_style_2',

			[

				'label'       => __( 'Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'sub_heading_style_2',

			[

				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),

				'type'        => Controls_Manager::TEXT,

				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),

				'default'     => __( '', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'post_number_2',

			[

				'label'       => __( 'Post Number', 'bdevs-elementor' ),

				'type'        => Controls_Manager::NUMBER,

				'default'     => __( '4', 'bdevs-elementor' ),

				'label_block' => true,

			]

		);	



		$this->add_control(

			'post_order_2',

			[

				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),

				'type'      => Controls_Manager::SELECT,

				'options'   => [

					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),

					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),

				],

				'default'   => 'desc',

			]

		);



		$this->end_controls_section();







		$this->start_controls_section(

			'section_content_layout',

			[

				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),

			]

		);



		$this->add_responsive_control(

			'align',

			[

				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),

				'type'    => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => esc_html__( 'Left', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-left',

					],

					'center' => [

						'title' => esc_html__( 'Center', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-center',

					],

					'right' => [

						'title' => esc_html__( 'Right', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-right',

					],

					'justify' => [

						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),

						'icon'  => 'fa fa-align-justify',

					],

				],

				'prefix_class' => 'elementor%s-align-',

				'description'  => 'Use align to match position',

				'default'      => 'center',

			]

		);



		$this->add_control(

			'show_heading',

			[

				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);	



		$this->add_control(

			'show_sub_heading',

			[

				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);		



		$this->add_control(

			'show_image',

			[

				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),

				'type'    => Controls_Manager::SWITCHER,

				'default' => 'yes',

			]

		);



		$this->end_controls_section();







	}



	public function render() {

		$settings  = $this->get_settings_for_display();

		$chose_style = $settings['chose_style'];

		?>

		

		<?php if( $chose_style == 'blog_style_1' ): ?>



		<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>

		<div class="blog-area pt-130 pb-100 blog-area-3" style="background-image: url(<?php echo wp_kses_post($settings['image']['url']); ?>)">

		<?php endif; ?>	



			<div class="container">



				<div class="row justify-content-center mb-50">



					<div class="col-xl-5 col-lg-6 col-md-10">



						<div class="section-title text-center">



							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>

							<h5><?php echo wp_kses_post($settings['sub_heading']); ?></h5>

							<?php endif; ?>

							

							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>

							<h3><?php echo wp_kses_post($settings['heading']); ?></h3>

							<?php endif; ?>

							

							<?php if (( '' !== $settings['icon_image']['url'] ) && ( $settings['show_image'] )): ?>

							<div class="icon">



								<img src="<?php echo wp_kses_post($settings['icon_image']['url']); ?>" alt="icon">



							</div>

							<?php endif; ?>



						</div>



					</div>



				</div>



				<div class="row">



					<?php 

					$order = $settings['post_order'];

					$post_number = $settings['post_number'];

					$wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'post',  'orderby' => 'ID', 'order' => $order));

					?>

					<?php 



					while ($wp_query -> have_posts()) : $wp_query -> the_post(); 

						?>



						<div class="col-xl-4 col-lg-6">



							<div class="blog-box-wrap blog-box-wrap-3">



								<div class="blog-box-thumb">



									<a href="<?php the_permalink();?>">



										<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="blog">



									</a>

									<div class="blog-box-date">
										<span><?php the_time('j');?></span>
										<span><?php the_time('F');?></span>
									</div>

								</div>



								<div class="blog-box-details">



									<div class="blog-box-meta">

										<span>

											<a href="#">

												<i class="far fa-user"></i> 

												<?php the_author_posts_link(); ?>

											</a>

										</span>

										<span>

											<a href="#">

												<i class="far fa-comments"></i><?php comments_number( esc_html__('0 Comments', 'fudee'), 

                                      esc_html__('1 Comment', 'fudee'), esc_html__('% Comments', 'fudee') ); ?>

											</a>

										</span>

									</div>



									<h4>



										<a href="<?php the_permalink();?>"><?php the_title();?></a>



									</h4>



									<p>



	                                <?php if(isset($fudee_redux_demo['blog_excerpt'])){?>



	                                    <?php echo esc_attr(fudee_excerpt2($fudee_redux_demo['blog_excerpt'])); ?>



	                                    <?php }else{?>



	                                    <?php echo esc_attr(fudee_excerpt2(12)); }?>



	                            	</p>



									<a href="<?php the_permalink();?>" class="read-more"><?php if(isset($fudee_redux_demo['read_more'])){?>



										<?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['read_more']));?>



									<?php }else{?>



										<?php echo esc_html__( 'Read more', 'fudee' );}?> <i class="far fa-angle-right"></i></a>



								</div>



							</div>



						</div>



					<?php endwhile; ?>



				</div>



			</div>



		</div>



		<?php elseif( $chose_style == 'blog_style_2' ): ?>



			<div class="blog-area-2 pt-130 pb-100">



				<div class="container">



					<div class="row justify-content-center mb-50">



						<div class="col-xl-5 col-lg-6 col-md-10">



							<div class="section-title text-center">



								<?php if (( '' !== $settings['sub_heading_style_2'] ) && ( $settings['show_sub_heading'] )): ?>

								<h5><?php echo wp_kses_post($settings['sub_heading_style_2']); ?></h5>

								<?php endif; ?>

								

								<?php if (( '' !== $settings['heading_style_2'] ) && ( $settings['show_heading'] )): ?>

								<h3><?php echo wp_kses_post($settings['heading_style_2']); ?></h3>

								<?php endif; ?>

								

								<?php if (( '' !== $settings['icon_image_style_2']['url'] ) && ( $settings['show_image'] )): ?>

								<div class="icon">



									<img src="<?php echo wp_kses_post($settings['icon_image_style_2']['url']); ?>" alt="icon">



								</div>

								<?php endif; ?>



							</div>



						</div>



					</div>



					<div class="row">



						<?php 

						$order_2 = $settings['post_order_2'];

						$post_number_2 = $settings['post_number_2'];

						$wp_query = new \WP_Query(array('posts_per_page' => $post_number_2,'post_type' => 'post',  'orderby' => 'ID', 'order' => $order_2));

						?>

						<?php 



						while ($wp_query -> have_posts()) : $wp_query -> the_post(); 

							?>



						<div class="col-xl-4 col-lg-6">



							<div class="blog-box-wrap-2">



								<div class="blog-box-thumb">



									<a href="<?php the_permalink();?>">



										<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="blog">



									</a>



								</div>



								<div class="blog-content blog-02-content">



									<div class="blog-box-meta">



										<span><a><i class="fal fa-user-circle"></i> <?php the_author_posts_link(); ?></a></span>



										<span><i class="far fa-calendar-check"></i> <?php the_time(get_option( 'date_format' ));?> </span>



									</div>



									<div class="blog-box-details">



										<h4>



											<a href="<?php the_permalink();?>"><?php the_title();?></a>



										</h4>



										<p><?php echo esc_attr(fudee_excerpt3(17));?>



										</p>



										<a href="<?php the_permalink();?>" class="a-btn read-more"><?php echo esc_html__( 'Read more', 'fudee' );?> <i class="fas fa-plus"></i></a>



									</div>



								</div>



							</div>



						</div>



						<?php endwhile; ?>



					</div>



				</div>



			</div>



		<?php endif; ?>



	<?php

	}



}