<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;

	global $product;
// Ensure visibility.
	if ( empty( $product ) || ! $product->is_visible() ) {
		return;
	}
	$fudee_redux_demo = get_option('redux_demo');
}
if ( $related_products ) : ?>

	<div class="wrapper gray-wrapper">
		<div class="container inner">
			<?php
			$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Products You Might Like', 'woocommerce' ) );

			if ( $heading ) :
				?>
				<h2 class="section-title text-center"><?php echo esc_html( $heading ); ?></h2>
			<?php endif; ?>
			<div class="grid grid-view boxed related-products">
				<div class="carousel owl-carousel gap-small" data-margin="0" data-dots="true" data-autoplay="false" data-autoplay-timeout="5000" data-responsive='{"0":{"items": "1"}, "768":{"items": "2"}, "992":{"items": "3"}}'>
					<?php 
					$args = array(   
						'post_type' => 'product',
						'paged' => $paged,
						'posts_per_page' => 6,
						'order' => desc,
						'orderby' => date, 
					);  
					$wp_query = new WP_Query($args);
					$i = 0;
					while ($wp_query -> have_posts()) : $wp_query -> the_post();
						$product_image = get_post_meta(get_the_ID(),'_cmb_product_image', true);     
						?>
						<div class="item item-detailed">
							<div class="item-inner">
								<div class="box bg-white shadow p-30">
									<figure class="main rounded mb-30">
										<div class="item-detailed-image"><?php
										  /**
										   * woocommerce_before_shop_loop_item hook.
										   *
										   * @hooked woocommerce_template_loop_product_link_open - 10
										   */
										  do_action( 'woocommerce_before_shop_loop_item' ); 

										  /**
										   * woocommerce_before_shop_loop_item_title hook.
										   *
										   * @hooked woocommerce_show_product_loop_sale_flash - 10
										   * @hooked woocommerce_template_loop_product_thumbnail - 10
										   */
										  do_action( 'woocommerce_before_shop_loop_item_title' );?><img src="<?php echo esc_url($product_image);?>" alt="" /></div>
										  <a href="<?php the_permalink();?>" class="hover-icon-first" data-tip="Add to Wishlist"><i class="jam jam-heart"></i></a>
										  <?php 
										  /**
										   * woocommerce_after_shop_loop_item hook.
										   *
										   * @hooked woocommerce_template_loop_product_link_close - 5
										   * @hooked woocommerce_template_loop_add_to_cart - 10
										   */
										  do_action( 'woocommerce_after_shop_loop_item' );
										  ?>
									</figure>
									<div class="item-content">
										<h2 class="post-title mb-10"><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h2>
										<?php 

									  /**
									   * woocommerce_after_shop_loop_item_title hook.
									   *
									   * @hooked woocommerce_template_loop_rating - 5
									   * @hooked woocommerce_template_loop_price - 10
									   */
									  do_action( 'woocommerce_after_shop_loop_item_title' ); ?>
									</div>
									<!-- /.item-content -->
								</div>
								<!--/.item-inner -->
							</div>
							<!-- /.box -->
						</div>

					<?php endwhile; ?>
					
					<!-- /.item -->
				</div>
				<!-- /.owl-carousel -->
			</div>
			<!-- /.grid-view -->
		</div>
		<!-- /.container -->
	</div>
	<?php
endif;

wp_reset_postdata();
