<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$fudee_redux_demo = get_option('redux_demo'); ?>


<?php if(isset($fudee_redux_demo['blog_image']['url']) && $fudee_redux_demo['blog_image']['url'] != ''){?>
    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo esc_url($fudee_redux_demo['blog_image']['url']);?>)">
<?php }else{?>    
    <section class="breadcrumb-area pt-180 pb-180 pt-md-120 pb-md-120 pt-xs-100 pb-xs-100 bg-fix" data-overlay="dark" data-opacity="7" style="background-image: url(<?php echo (get_template_directory_uri().'/assets/img/bg/breadcrumb-bg.jpg');?>)">
<?php } ?>   
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <div class="breadcrumb-content">
                    	<?php if(isset($fudee_redux_demo['checkout_title']) && $fudee_redux_demo['checkout_title'] != ''){?>
                       		<h3 class="title"><?php echo esc_attr($fudee_redux_demo['checkout_title']);?></h3>
                        <?php }else{ ?>
                        	<h3 class="title"><?php echo esc_html__( 'Checkout', 'fudee' )?></h3>
                        <?php } ?>
                        <ul>
                            <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'fudee' )?></a></li>
                            <?php if(isset($fudee_redux_demo['checkout_title']) && $fudee_redux_demo['checkout_title'] != ''){?>
                                <li class="active"><?php echo esc_attr($fudee_redux_demo['checkout_title']);?></li>
                            <?php }else{ ?>
                                <li class="active"><?php echo esc_html__( 'Checkout', 'fudee' )?></li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

<div class="wrapper light-wrapper">
	<div class="container inner">
		<div class="row">

			<?php
			do_action( 'woocommerce_before_checkout_form', $checkout );


// If checkout registration is disabled and not logged in, the user cannot checkout.
			if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
				echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
				return;
			}

			?>
			<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

				<?php if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>

					<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
					<div class="row">
						<div class="col-lg-6">
							<div class="checkbox-form">
								<?php do_action( 'woocommerce_checkout_billing' ); ?>
							</div>

							<div class="order-notes pb-80">
								<?php do_action( 'woocommerce_checkout_shipping' ); ?>
							</div>
						</div>

						<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>


						<div class="col-lg-6">
							<div class="your-order mb-30 ">
								<h3 id="order_review_heading"><?php _e( 'Your order', 'woocommerce' ); ?></h3>

								<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

								<div id="order_review" class="woocommerce-checkout-review-order">
									<?php do_action( 'woocommerce_checkout_order_review' ); ?>
								</div>
							</div>
						</div>
					</div>
					<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
				<?php endif; ?>
			</form>
			<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
		</div>
	</div>
</div>