<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php $fudee_redux_demo = get_option('redux_demo'); ?>
<head>
    <!-- Meta Tags -->
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
        ?>
    <link rel="shortcut icon" href="<?php if(isset($fudee_redux_demo['favicon']['url'])){?><?php echo esc_url($fudee_redux_demo['favicon']['url']); ?><?php }?>">
    <?php }?>
    <?php wp_head(); ?> 

</head>
<body <?php body_class('home-page-2'); ?>>
        <!-- start preloader -->
<div id="preloader">
    <div class="preloader">
        <span></span>
        <span></span>
    </div>
</div>
<!-- preloader end  -->

<!--    header-area start    -->
<header class="header-area">
    <div class="header-top-2">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-1 col-lg-1">
                    <div class="sidebar-open">
                        <a href="javascript:void(0);">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                 width="35px" height="23px">
                                <path fill-rule="evenodd" fill="rgb(31, 43, 59)"
                                      d="M0.000,13.000 L0.000,10.000 L35.000,10.000 L35.000,13.000 L0.000,13.000 ZM0.000,-0.000 L30.000,-0.000 L30.000,2.999 L0.000,2.999 L0.000,-0.000 ZM26.000,23.000 L0.000,23.000 L0.000,19.999 L26.000,19.999 L26.000,23.000 Z"/>
                            </svg>
                        </a>
                    </div>
                </div>
                <div class="col-xl-10 col-lg-10">
                    <div class="main-menu-wrap-2">
                        <nav class="main-menu">
                            <?php 
                            wp_nav_menu( 
                                array( 
                                    'theme_location' => 'primary',
                                    'container' => '',
                                    'menu_class' => '', 
                                    'menu_id' => '',
                                    'menu'            => '',
                                    'container_class' => '',
                                    'container_id'    => '',
                                    'echo'            => true,
                                    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                    'walker'            => new fudee_wp_bootstrap_navwalker(),
                                    'before'          => '',
                                    'after'           => '',
                                    'link_before'     => '',
                                    'link_after'      => '',
                                    'items_wrap'      => '<ul class="%2$s">%3$s</ul>',
                                    'depth'           => 0,        
                                )
                            ); ?>
                        </nav>
                    </div>
                </div>
                <div class="col-xl-1 col-lg-1">
                </div>
            </div>
        </div>
    </div>
    <div class="header-bottom-2">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-3 col-lg-3 d-xl-block d-lg-block d-none">
                    <div class="header-info-2">
                        <div class="icon">
                            <i class="far fa-phone"></i>
                        </div>
                        <div class="info">
                            <?php if(isset($fudee_redux_demo['top_header_phone_title'])){?>
                            <span><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_phone_title']));?></span>
                            <a href="<?php echo esc_attr($fudee_redux_demo['top_header_phone_link']);?>"><?php echo esc_attr($fudee_redux_demo['top_header_phone_title']);?></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-7 col-lg-6 col-md-4 col">
                    <?php if(isset($fudee_redux_demo['header_logo_2']['url']) && $fudee_redux_demo['header_logo_2'] != ''){?>
                        <div class="logo-2">
                            <a href="<?php echo esc_url(home_url('/')); ?>">
                                <img src="<?php echo esc_url($fudee_redux_demo['header_logo_2']['url']);?>" alt="logo">
                            </a>
                        </div>
                    <?php }else{?>
                        <div class="logo-2">
                            <a href="<?php echo esc_url(home_url('/')); ?>">
                                <img src="<?php echo (get_template_directory_uri().'/assets/img/logo/logo-black.png');?>" alt="logo">
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="col-xl-2 col-lg-3 col-md-8 col text-right">
                    <div class="header-lang">
                        <div class="lang-icon">
                             <?php if(isset($fudee_redux_demo['header_langduage_image']['url']) && $fudee_redux_demo['header_langduage_image']['url'] != ''){?>
                                <img src="<?php echo esc_url($fudee_redux_demo['header_langduage_image']['url']);?>" alt="en">
                            <?php }else{ ?>
                                <img src="<?php echo (get_template_directory_uri().'/assets/img/icon/lang-en.png');?>" alt="en">
                            <?php } ?>
                            <a href="<?php echo esc_url($fudee_redux_demo['link_lang_1']);?>"><?php echo esc_attr($fudee_redux_demo['header_lang_1']);?> <i class="far fa-angle-down"></i></a>
                        </div>
                        <ul class="header-lang-list">
                            <?php if(isset($fudee_redux_demo['header_lang_1'])){?>
                            <li><a href="<?php echo esc_url($fudee_redux_demo['link_lang_1']);?>"><?php echo esc_attr($fudee_redux_demo['header_lang_1']);?></a></li>
                            <?php } ?>
                            <?php if(isset($fudee_redux_demo['header_lang_2'])){?>
                            <li><a href="<?php echo esc_url($fudee_redux_demo['link_lang_2']);?>"><?php echo esc_attr($fudee_redux_demo['header_lang_2']);?></a></li>
                            <?php } ?>
                            <?php if(isset($fudee_redux_demo['header_lang_3'])){?>
                            <li><a href="<?php echo esc_url($fudee_redux_demo['link_lang_3']);?>"><?php echo esc_attr($fudee_redux_demo['header_lang_3']);?></a></li>
                            <?php } ?>
                            <?php if(isset($fudee_redux_demo['header_lang_4'])){?>
                            <li><a href="<?php echo esc_url($fudee_redux_demo['link_lang_4']);?>"><?php echo esc_attr($fudee_redux_demo['header_lang_4']);?></a></li>
                            <?php } ?>
                        </ul>
                    </div>
                    <div class="open-mobile-menu">
                        <a href="javascript:void(0);">
                            <i class="far fa-bars"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-search">
            <a href="javascript:void(0);"><i class="far fa-search"></i></a>
        </div>
        <div class="social-share">
            <a href="javascript:void(0);"><i class="far fa-plus"></i></a>
            <div class="social-icon">
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_facebook']);?>" class="facebook"><i class="fab fa-facebook-f"></i></a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_twitter']);?>" class="twitter"><i class="fab fa-twitter"></i></a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_pinterest']);?>" class="pinterest"><i class="fab fa-pinterest-p"></i></a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_instagram']);?>" class="instagram"><i class="fab fa-instagram"></i></a>
            </div>
        </div>
    </div>
</header>
<!--    header-area end    -->

<!--    slide-bar Start   -->
<aside class="slide-bar">
    <div class="close-mobile-menu">
        <a href="javascript:void(0);"><i class="fas fa-times"></i></a>
    </div>
    <!--    Mobile Menu Start   -->
    <nav class="side-mobile-menu">
        <?php 
        wp_nav_menu( 
            array( 
                'theme_location' => 'primary',
                'container' => '',
                'menu_class' => '', 
                'menu_id' => '',
                'menu'            => '',
                'container_class' => '',
                'container_id'    => '',
                'echo'            => true,
                'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                'walker'            => new fudee_wp_bootstrap_navwalker(),
                'before'          => '',
                'after'           => '',
                'link_before'     => '',
                'link_after'      => '',
                'items_wrap'      => '<ul id="mobile-menu-active" class="%2$s">%3$s</ul>',
                'depth'           => 0,        
            )
        ); ?>
    </nav>
    <!--    Mobile Menu End    -->

    <!--    Offset Sidebar Start   -->
    <div class="sidebar-widget-wrapper">
        <!-- start side widget -->
        <?php if(isset($fudee_redux_demo['header_logo']) && $fudee_redux_demo['header_logo'] != ''){?>
            <div class="sidebar-widget logo-side">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?php echo esc_url($fudee_redux_demo['header_logo']['url']);?>" alt="logo">
                </a>
            </div>
        <?php }else{?>
            <div class="sidebar-widget logo-side">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?php echo (get_template_directory_uri().'/assets/img/logo/logo.png');?>" alt="logo">
                </a>
            </div>
        <?php } ?>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="info-wdget">
                <h4 class="widget-title"><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_address_title']));?></h4>
                <p>
                    <?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_address_subtitle']));?>
                </p>
            </div>
        </div>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="info-wdget">
                <h4 class="widget-title"><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_phone_title']));?></h4>
                <p><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_phone_subtitle_1']));?></p>
                <p><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_phone_subtitle_2']));?></p>
            </div>
        </div>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="info-wdget">
                <h4><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_email_title']));?></h4>
                <p><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_email_subtitle_1']));?></p>
                <p><?php echo htmlspecialchars_decode(esc_attr($fudee_redux_demo['header_email_subtitle_2']));?></p>
            </div>
        </div>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="instagram">
                <?php if(isset($fudee_redux_demo['header_image_1']['url']) && $fudee_redux_demo['header_image_1']['url'] != ''){?>
                        <a href="#">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_1']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="#">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p1.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_2']['url']) && $fudee_redux_demo['header_image_2']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_2']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p2.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_3']['url']) && $fudee_redux_demo['header_image_3']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_3']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p3.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_4']['url']) && $fudee_redux_demo['header_image_4']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_4']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p4.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_5']['url']) && $fudee_redux_demo['header_image_5']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_5']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p5.jpg');?>" alt="">
                        </a>
                    <?php } ?>
                    <?php if(isset($fudee_redux_demo['header_image_6']['url']) && $fudee_redux_demo['header_image_6']['url'] != ''){?>
                        <a href="">
                            <img src="<?php echo esc_url($fudee_redux_demo['header_image_6']['url']);?>" alt="">
                        </a>
                    <?php }else{?>
                        <a href="">
                            <img src="<?php echo (get_template_directory_uri().'/assets/img/portfolio/p6.jpg');?>" alt="">
                        </a>
                    <?php } ?>
            </div>
        </div>
        <!-- end side widget -->

        <!-- start side widget -->
        <div class="sidebar-widget">
            <div class="social-widget">
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_facebook']);?>">
                    <i class="fab fa-facebook-f"></i>
                </a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_twitter']);?>">
                    <i class="fab fa-twitter"></i>
                </a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_google']);?>">
                    <i class="fab fa-google-plus-g"></i>
                </a>
                <a href="<?php echo esc_url($fudee_redux_demo['header_link_instagram']);?>">
                    <i class="fab fa-instagram"></i>
                </a>
            </div>
        </div>
        <!-- end side widget -->
    </div>
    <!--    Offset Sidebar End    -->
</aside>
<div class="body-overlay"></div>
<!--    slide-bar End    -->

<!--    search-area start    -->
<div class="search-area">
    <div class="search-area-bg"></div>
    <a href="#" class="search-close">
        <i class="far fa-times"></i>
    </a>
    <div class="search-form">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8">
                    <?php get_search_form() ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!--    search-area end    -->

<!--    main-area start    -->
<main>