<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsFAQ extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-faq';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'FAQ Area', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'bdevs-faq' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_faq',
			[
				'label' => esc_html__( 'FAQ Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image',
			[
				'label'   => esc_html__( 'FAQ Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your FAQ Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'FAQ Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				
				'fields' => [	
					[
						'name'        => 'faq_select',
						'label'     => esc_html__( 'FAQ Select', 'bdevs-elementor' ),
						'type'      => Controls_Manager::SELECT,
						'dynamic' => [ 'active' => true ],
						'options'   => [
							'1'  => esc_html__( 'Show', 'bdevs-elementor' ),
							'2'  => esc_html__( 'Hide', 'bdevs-elementor' ),
						],
						'default'   => '2',
					],
					[
						'name'        => 'tab_id_1',
						'label'       => esc_html__( 'ID 1', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_id_2',
						'label'       => esc_html__( 'ID 2', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],	
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		

		$this->start_controls_section(
			'section_content_button',
			[
				'label'     => esc_html__( 'Button', 'bdevs-elementor' ),
				'condition' => [
					'show_button' => 'yes',
				],
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'       => esc_html__( 'Button Text', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Read More', 'bdevs-elementor' ),
				'placeholder' => esc_html__( 'Read More', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'icon',
			[
				'label'       => esc_html__( 'Icon', 'bdevs-elementor' ),
				'type'        => Controls_Manager::ICON,
				'label_block' => true,
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		?>
		<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>
		<div class="faq-area bg-fix" style="background-image: url(<?php echo wp_kses_post($settings['image']['url']); ?>)">
		<?php endif; ?>	
		<div class="container-fluid pl-0 pr-0">
			<div class="row no-gutters justify-content-end">
				<div class="col-xl-7 col-lg-8">
					<div class="faq-wrap">
						<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
						<h3><?php echo wp_kses_post($settings['heading']); ?></h3>
						<?php endif; ?>	
						<div class="accordion-wrapper" id="accordion-1">
							
							<?php foreach ( $settings['tabs'] as $item ) : ?>
							
							<?php if( wp_kses_post($item['faq_select']) == '1'): ?>
							<div class="accordion-wrap">
								<div class="accordion-header" id="<?php echo wp_kses_post($item['tab_id_1']); ?>">
									<?php if ( '' !== $item['tab_title'] ) : ?>
									<button class="collapsed" type="button" data-toggle="collapse"
									        data-target="#<?php echo wp_kses_post($item['tab_id_2']); ?>"
									        aria-expanded="true" aria-controls="<?php echo wp_kses_post($item['tab_id_2']); ?>">
										<?php echo wp_kses_post($item['tab_title']); ?>
									</button>
									<?php endif; ?>
								</div>
								<div id="<?php echo wp_kses_post($item['tab_id_2']); ?>" class="collapse show" aria-labelledby="<?php echo wp_kses_post($item['tab_id_1']); ?>"
								     data-parent="#accordion-1">
								     <?php if ( '' !== $item['tab_subtitle'] ) : ?>
									<div class="accordion-body">
										<?php echo wp_kses_post($item['tab_subtitle']); ?>
									</div>
									<?php endif; ?>
								</div>
							</div>
							<?php else: ?>
								<div class="accordion-wrap">
								<div class="accordion-header" id="<?php echo wp_kses_post($item['tab_id_1']); ?>">
									<?php if ( '' !== $item['tab_title'] ) : ?>
									<button class="collapsed" type="button" data-toggle="collapse"
									        data-target="#<?php echo wp_kses_post($item['tab_id_2']); ?>"
									        aria-expanded="true" aria-controls="<?php echo wp_kses_post($item['tab_id_2']); ?>">
										<?php echo wp_kses_post($item['tab_title']); ?>
									</button>
									<?php endif; ?>
								</div>
								<div id="<?php echo wp_kses_post($item['tab_id_2']); ?>" class="collapse" aria-labelledby="<?php echo wp_kses_post($item['tab_id_1']); ?>"
								     data-parent="#accordion-1">
								     <?php if ( '' !== $item['tab_subtitle'] ) : ?>
									<div class="accordion-body">
										<?php echo wp_kses_post($item['tab_subtitle']); ?>
									</div>
									<?php endif; ?>
								</div>
							</div>
							<?php endif; ?> 
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
	}

}