<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>

  <?php if ( have_comments() ) : ?>
            
    <div class="blog-comments">
      <div class="blog-comment-title mb-30">
        <h2><?php comments_number( esc_html__('0 Comments', 'fudee'), esc_html__('1 Comment', 'fudee'), esc_html__('% Comments', 'fudee')); ?></h2>
      </div>
      <div class="latest-comments">
        <ul>
          <?php wp_list_comments('callback=fudee_theme_comment'); ?>
        </ul> <!-- media-lst -->
      </div>
    </div>
                                   
        <?php
                    // Are there comments to navigate through?
                    if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
                ?>
            <div class="text-center">
              <ul class="pagination">
                <li>
                  <?php //Create pagination links for the comments on the current post, with single arrow heads for previous/next
                  paginate_comments_links( array('prev_text' => '<i class="fa fa-angle-left"></i>', 'next_text' => '<i class="fa fa-angle-right"></i>'));  ?>
                </li> 
              </ul>
            </div>
<?php endif; // Check for comment navigation ?>
<?php endif; ?>
<?php
    if ( is_singular() ) wp_enqueue_script( "comment-reply" );
        $aria_req = ( $req ? " aria-required='true'" : '' );
        $comment_args = array(
                'id_form' => 'contacts-form',        
                'class_form' => 'conatct-post-form',                         
                'title_reply'=> esc_html__( 'Leave a comment', 'fudee' ),
                'fields' => apply_filters( 'comment_form_default_fields', array(
                    'author' => '<div class="col-xl-12">
                                    <div class="contact-icon contacts-name">
                                        <input type="text" placeholder="'.esc_attr__('Your Name....', 'fudee').'" name="author">
                                    </div>
                                  </div>',
                    'email' => '<div class="col-xl-12">
                                    <div class="contact-icon contacts-email">
                                        <input type="email" placeholder="'.esc_attr__('Your Email....', 'fudee').'" name="email">
                                    </div>
                                </div>',
                    'website' => '<div class="col-xl-12">
                                      <div class="contact-icon contacts-website">
                                        <input type="text" placeholder="'.esc_attr__('Your Website....', 'fudee').'" name="website" id="website">
                                    </div>
                                </div>'                          
                ) ),   
                'comment_field' => '<div class="col-xl-12">
                                      <div class="contact-icon contacts-message">
                                        <textarea name="comment"'.$aria_req.' class="form-control" id="comments" row="10" cols="30" placeholder="'.esc_attr__('Write a comment', 'fudee').'"></textarea>
                                      </div>
                                    </div>',                    
                 'label_submit' => 'Post comment',
                 'class_submit' => 'a-btn btn-theme',
                 'comment_notes_before' => '',
                 'comment_notes_after' => '',               
        )
    ?>
  <?php if ( comments_open() ) : ?>
    <div class="post-comments-form">
    <?php comment_form($comment_args); ?>
    </div>
<?php endif; ?> 